% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_results.R
\name{test_results}
\alias{test_results}
\title{Get RMSE & explained variance for warm and cold test results}
\usage{
test_results(m, d, test.results = numeric(0), verbose = T,
  warm.resp = numeric(0), test.m1 = numeric(0), test.m2 = numeric(0),
  test.m3 = numeric(0), test.m1m2 = numeric(0), test.m1m3 = numeric(0),
  test.m2m3 = numeric(0), test.m1m2m3 = numeric(0))
}
\arguments{
\item{m}{a \code{CP_model} or \code{Tucker_model} object}

\item{d}{an input data object created with \code{input_data}}

\item{test.results}{an object generated by this function that will combined with the new results}

\item{verbose}{Logical indicating whether to print the resulting prediction measures (TRUE)}

\item{warm.resp}{True responses for warm test data (optional).}

\item{test.m1}{True responses for mode 1 cold test data (optional).}

\item{test.m2}{True responses for mode 2 cold test data (optional).}

\item{test.m3}{True responses for mode 3 cold test data (optional).}

\item{test.m1m2}{True responses for mode 1/2 combination cold test data (optional).}

\item{test.m1m3}{True responses for mode 1/3 combination cold test data (optional).}

\item{test.m2m3}{True responses for mode 2/3 combination cold test data (optional).}

\item{test.m1m2m3}{True responses for mode 1/2/3 combination cold test data (optional).}
}
\value{
list of results TODO: add more here
}
\description{
Get RMSE & explained variance for warm and cold test results
}
\examples{
data.params <- get_data_params(c('decomp=Tucker'))
toy <- mk_toy(data.params)

# Make training data object excluding the first two samples for modes 1 & 2.
train.data <- input_data$new(mode1.X=toy$mode1.X[-(1:2),-1],
                             mode2.X=toy$mode2.X[-(1:2),-1],
                             mode3.X=toy$mode3.X[,-1],
                             resp=toy$resp)
# Remove some responses for warm prediction
warm.ind <- sample(1:prod(dim(train.data$resp)), 20)
warm.resp <- train.data$resp[warm.ind]
train.data$resp[warm.ind] <- NA

# Make testing objects 
m1.test.data <- input_data$new(mode1.X=toy$mode1.X[1:2,-1],
                               mode2.X=toy$mode2.X[-(1:2),-1],
                               mode3.X=toy$mode3.X[,-1],
                               resp=toy$resp[1:2,-(1:2),])
m2.test.data <- input_data$new(mode1.X=toy$mode1.X[-(1:2),-1],
                               mode2.X=toy$mode2.X[1:2,-1],
                               mode3.X=toy$mode3.X[,-1],
                               resp=toy$resp[-(1:2),1:2,])
m1m2.test.data <- input_data$new(mode1.X=toy$mode1.X[1:2,-1],
                                 mode2.X=toy$mode2.X[1:2,-1],
                                 mode3.X=toy$mode3.X[,-1],
                                 resp=toy$resp[1:2,1:2,])
                               
model.params <- get_model_params(c('decomp=Tucker'))
toy.model <- mk_model(train.data, model.params)
toy.model$rand_init(model.params)

test.results <- numeric(0)
test_results(m=toy.model, d=train.data, test.results=test.results,
             warm.resp=warm.resp, test.m1=m1.test.data, test.m2=m2.test.data, 
             test.m1m2=m1m2.test.data)
}

