% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbg-cnbd-k.R
\name{mbgcnbd.Expectation}
\alias{mbgcnbd.Expectation}
\alias{bgcnbd.Expectation}
\title{(M)BG/CNBD-k Expectation}
\usage{
mbgcnbd.Expectation(params, t)

bgcnbd.Expectation(params, t)
}
\arguments{
\item{params}{A vector with model parameters \code{k}, \code{r},
\code{alpha}, \code{a} and \code{b}, in that order.}

\item{t}{Length of time for which we are calculating the expected number of repeat transactions.}
}
\value{
Number of repeat transactions a customer is expected to make in a time period of length t.
}
\description{
Returns the number of repeat transactions that a randomly chosen customer
(for whom we have no prior information) is expected to make in a given time
period, i.e. \eqn{E(X(t) | k, r, alpha, a, b)}.
}
\details{
Note: Computational time increases with the number of unique values of
\code{t}.
}
\examples{
\dontrun{
data("groceryElog")
cbs <- elog2cbs(groceryElog)
params <- mbgcnbd.EstimateParameters(cbs)
mbgcnbd.Expectation(params, t = c(26, 52))
}
}
\references{
(M)BG/CNBD-k: Reutterer, T., Platzer, M., & Schroeder, N. (2020).
  Leveraging purchase regularity for predicting customer behavior the easy
  way. International Journal of Research in Marketing.
  \doi{10.1016/j.ijresmar.2020.09.002}
}
