% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build.R
\name{build_call}
\alias{build_call}
\title{Build an API call (uses the appropriate function based on the data item)}
\usage{
build_call(data_item, api_key, service_type = "csv", api_version = "v1", ...)
}
\arguments{
\item{data_item}{character string; data item to be retrieved}

\item{api_key}{character string; user's API key}

\item{service_type}{character string; one of "csv" or "xml" to define return format}

\item{api_version}{character string; API version to use - currently only on version 1}

\item{...}{values to be passed to appropriate build_x_call function}
}
\description{
Build an API call (uses the appropriate function based on the data item)
}
\examples{
build_call(data_item = "TEMP", api_key = "12345", from_date = "12 Jun 2018",
to_date = "13 Jun 2018", service_type = "csv")
build_call(data_item = "QAS", api_key = "12345",
settlement_date = "01 Jun 2019", service_type = "xml")
}
\seealso{
\code{\link{build_b_call}}

\code{\link{build_remit_call}}

\code{\link{build_legacy_call}}

Other call-building functions: 
\code{\link{build_b_call}()},
\code{\link{build_legacy_call}()},
\code{\link{build_remit_call}()}
}
\concept{call-building functions}
