% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIEN.R
\name{BIEN_ranges_intersect_species}
\alias{BIEN_ranges_intersect_species}
\title{Download range maps that intersect the range of a given species.}
\usage{
BIEN_ranges_intersect_species(
  species,
  directory = NULL,
  species.names.only = FALSE,
  include.focal = TRUE,
  return.species.list = TRUE,
  include.gid = FALSE,
  ...
)
}
\arguments{
\item{species}{Focal species (or a vector of species) for which to extract intersecting ranges.}

\item{directory}{Directory that range maps should be saved in.  If none is specified, range maps will be saved in the current working directory.}

\item{species.names.only}{Return species names rather than spatial data? Default is FALSE.}

\item{include.focal}{Should a range for the focal species be downloaded? Default is TRUE.}

\item{return.species.list}{Should a species list be returned in addition to downloading range maps?  Default is FALSE}

\item{include.gid}{Should the files returned have a unique GID appended to them? This is needed if downloading multiple maps for the same species.}

\item{...}{Additional arguments passed to internal functions.}
}
\value{
Range maps for all available species that intersect the range of the focal species.
}
\description{
BIEN_ranges_intersect_species extracts range maps for a specified bounding box.
}
\note{
Details on the construction of BIEN range maps is available at https://bien.nceas.ucsb.edu/bien/biendata/bien-3/
}
\examples{
\dontrun{
temp_dir <- file.path(tempdir(), "BIEN_temp") #Set a working directory
BIEN_ranges_intersect_species(species = "Carnegiea_gigantea",
directory = temp_dir,include.focal = TRUE)
species_vector<-c("Carnegiea_gigantea","Echinocereus coccineus")
BIEN_ranges_intersect_species(species = species_vector,species.names.only = TRUE)
}
}
\seealso{
Other range functions: 
\code{\link{BIEN_ranges_box}()},
\code{\link{BIEN_ranges_genus}()},
\code{\link{BIEN_ranges_list}()},
\code{\link{BIEN_ranges_load_species}()},
\code{\link{BIEN_ranges_sf}()},
\code{\link{BIEN_ranges_shapefile_to_skinny}()},
\code{\link{BIEN_ranges_skinny_ranges_to_richness_raster}()},
\code{\link{BIEN_ranges_species_bulk}()},
\code{\link{BIEN_ranges_species}()}
}
\concept{range functions}
