% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Size.Split.R
\name{Size.Split}
\alias{Size.Split}
\title{Sample size calculator for split-plot design}
\usage{
Size.Split(whole.factor, whole.factor.lev,split.factor,
split.factor.lev, order, delta_type, delta, alpha, beta)
}
\arguments{
\item{whole.factor}{the number of whole factor}

\item{whole.factor.lev}{whole factor levels}

\item{split.factor}{the number of split factor}

\item{split.factor.lev}{split factor levels}

\item{order}{building the model with main or including the interaction effects ;
1 : only main effects(default) , 2 : both main and two-way interaction effects}

\item{delta_type}{type of standardized effect size ; 1 : standard deviation type(default), 2 : range of effect type}

\item{delta}{lists of effects size; The first and the second column is effect size of main and two-way interaction effects, respectively. The third and the forth column is standard devitaion of whole noise and noise, respectively.}

\item{alpha}{Type I error ; 0.05 (default)}

\item{beta}{Type II error ; 0.20 (default)}
}
\value{
model, optimal sample size and detectable standardized effect sizes
}
\description{
Sample size in split-plot design is computed in order to detect a certain standardized effect size "delta" with power "1-beta" at the significance level "alpha".
}
\details{
The linear model for the split-plot design is
\deqn{y_{ijklm} = \mu + \tau_i +\beta_j +\gamma_k + (\beta\tau)_{ik} +\theta_{ijk} + \delta_l +\lambda_m +(\delta\lambda)_{im} +(\beta\delta)_{jl}+(\beta\lambda)_{jm}+(\gamma\delta)_{kl}+(\delta\lambda)_{lm}+\epsilon_{ijklm}}
where \eqn{\tau_i} represents the replicate effect, \eqn{\beta_j ,\gamma_k} represents the whole plot main effects, \eqn{\theta_{ijk}} is the whole plot error, \eqn{\delta_l ,\lambda_m} represent the subplot main effects, and \eqn{\epsilon_{ijklm}} is the subplot error.
}
\examples{
#only main effects
A<-Size.Split(whole.factor=2, whole.factor.lev=c(2,2),
split.factor=2, split.factor.lev=c(2,2), order=1,
delta_type=1, delta=c(1,0,1,1), alpha=0.05, beta=0.2)
A$model
A$n
A$Delta

#including two-way interaction effects
B<-Size.Split(whole.factor=2, whole.factor.lev=c(2,2),
split.factor=2, split.factor.lev=c(2,2), order=2,
delta_type=1, delta=c(1,1,1,1), alpha=0.05, beta=0.2)

}
\references{
Lenth,R.V., 2006-9. Java Applets for Power and Sample Size[Computer software]. Retrieved March 27, 2018 from http://www.stat.uiowa.edu/~rlenth/Power

Lim, Yong Bin, 1998. Study on the Size of Minimal Standardized Detectable Difference in Balanced Design of Experiments, \emph{Journal of the Korean society for Quality Management}, 26(4),239-249.

Marvin, A., Kastenbaum, A. and Hoel, D.G., 1970. Sample size requirements : one-way analysis of variance, \emph{Biometrika} 57(2),421-430.

Montgomery, Douglas C., 2013. Design and analysis of experiments. John wiley & sons. ISBN: 978-1-118-14692-7
}
