% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.bas.R
\name{plot.bas}
\alias{plot.bas}
\title{Plot Diagnostics for an BAS Object}
\usage{
\method{plot}{bas}(x, which = c(1:4), caption = c("Residuals vs Fitted",
  "Model Probabilities", "Model Complexity", "Inclusion Probabilities"),
  panel = if (add.smooth) panel.smooth else points, sub.caption = NULL,
  main = "", ask = prod(par("mfcol")) < length(which) && dev.interactive(),
  col.in = 2, col.ex = 1, col.pch = 1, cex.lab = 1, ..., id.n = 3,
  labels.id = NULL, cex.id = 0.75, add.smooth = getOption("add.smooth"),
  label.pos = c(4, 2))
}
\arguments{
\item{x}{\code{bas} BMA object result of 'bas'}

\item{which}{if a subset of the plots is required, specify a subset of the
numbers '1:4'}

\item{caption}{captions to appear above the plots}

\item{panel}{panel function.  The useful alternative to 'points',
'panel.smooth' can be chosen by 'add.smooth = TRUE'}

\item{sub.caption}{common title-above figures if there are multiple; used as
'sub' (s.'title') otherwise.  If 'NULL', as by default, a possible shortened
version of \code{deparse(x$call)} is used}

\item{main}{title to each plot-in addition to the above 'caption'}

\item{ask}{logical; if 'TRUE', the user is asked before each plot, see
'par(ask=.)'}

\item{col.in}{color for the included variables}

\item{col.ex}{color for the excluded variables}

\item{col.pch}{color for points in panels 1-3}

\item{cex.lab}{graphics parameter to control size of variable names}

\item{...}{other parameters to be passed through to plotting functions}

\item{id.n}{number of points to be labelled in each plot, starting with the
most extreme}

\item{labels.id}{vector of labels, from which the labels for extreme points
will be chosen.  'NULL' uses observation numbers}

\item{cex.id}{magnification of point labels.}

\item{add.smooth}{logical indicating if a smoother should be added to most
plots; see also 'panel' above}

\item{label.pos}{positioning of labels, for the left half and right half of
the graph respectively, for plots 1-4}
}
\description{
Four plots (selectable by 'which') are currently available: a plot of
residuals against fitted values, Cumulative Model Probabilities, log
marginal likelihoods versus model dimension, and marginal inclusion
probabilities.
}
\details{
This provides a panel of 4 plots: the first is a plot of the residuals
versus fitted values under BMA. The second is a plot of the cumulative
marginal likelihoods of models; if the model space cannot be enumerated then
this provides some indication of whether the probabilities are leveling off.
The third is a plot of log marginal likelihood versus model dimension and
the fourth plot show the posterior marginal inclusion probabilities.
}
\examples{

data(Hald)
hald.gprior =  bas.lm(Y~ ., data=Hald, prior="g-prior", alpha=13,
                      modelprior=beta.binomial(1,1),
                      initprobs="eplogp")

plot(hald.gprior)


}
\seealso{
\code{\link{plot.coef.bas}} and \code{\link{image.bas}}.

Other bas plots: \code{\link{image.bas}},
  \code{\link{plot.coef.bas}}
}
\author{
Merlise Clyde, based on plot.lm by John Maindonald and Martin
Maechler
}
\keyword{regression}
