% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frontend.R
\name{get_record_count}
\alias{get_record_count}
\title{Count number of records in a query}
\usage{
get_record_count(..., api_key = NULL)
}
\arguments{
\item{...}{Query parameters and their values to pass to Arctos to search.
For example, `scientific_name = "Canis lupus"``}

\item{api_key}{(character) The API key to use for this request.
The default, \code{NULL}, uses the package's default API key.}
}
\value{
The number of records matching the given query, as an integer.
}
\description{
Request from Arctos the total number of records that match a specific query.
A list of possible query keys can be obtained from the output of
\code{\link{get_query_parameters}}.
}
\examples{
library(ArctosR)

count <- get_record_count(
  scientific_name = "Canis lupus", guid_prefix = "MSB:Mamm"
)

}
