% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultiPhasesGap.R
\name{MultiPhasesGap}
\alias{MultiPhasesGap}
\title{Gap or hiatus between a succession of groups (for groups in temporal order constraint)}
\usage{
MultiPhasesGap(
  data,
  position_minimum,
  position_maximum = position_minimum + 1,
  level = 0.95
)
}
\arguments{
\item{data}{Data frame containing the output of the MCMC algorithm.}

\item{position_minimum}{Numeric vector containing the column number
corresponding to the minimum of the events included in each group.}

\item{position_maximum}{Numeric vector containing the column number
corresponding to the end of the phases set in the same order
as in \code{position_minimum}.}

\item{level}{Probability corresponding to the level of confidence.}
}
\value{
Returns a matrix of values containing the level of confidence
and the endpoints of the gap for each pair of successive groups. The
result is given in calendar years (BC/AD).
}
\description{
Finds, if it exists, a gap or hiatus between two successive groups.  This gap or hiatus
is the longest interval that satisfies
\eqn{P(Phase1Max < IntervalInf < IntervalSup < Phase2Min | M) = level}
}
\details{
For each \code{i}, \code{MultiPhasesGap()} computes the gap interval
for the phase defined by its minimum \code{position_minimum[i]} and
its maximum \code{position_maximum[i]}. The default value of
\code{position_maximum} corresponds to CSV files exported from
\href{https://chronomodel.com/}{ChronoModel} software.
}
\examples{
  # Data extracted from ChronoModel software
  data(Phases)
  # List of the name of the groups
  names(Phases)
  # Stipulating position_maximum
  MultiPhasesGap(Phases, position_minimum = c(4, 2), position_maximum = c(5, 3))
  # In this case, equivalent to
  MultiPhasesGap(Phases, position_minimum = c(4, 2))

}
\author{
Anne Philippe, \email{Anne.Philippe@univ-nantes.fr} and

Marie-Anne Vibet, \email{Marie-Anne.Vibet@univ-nantes.fr}
}
