% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{usefulness}
\alias{usefulness}
\title{Usefulness criterion}
\usage{
usefulness(
  pop,
  trait = 1,
  use = "gv",
  p = 0.1,
  selectTop = TRUE,
  simParam = NULL,
  ...
)
}
\arguments{
\item{pop}{and object of \code{\link{Pop-class}} or
\code{\link{HybridPop-class}}}

\item{trait}{the trait for selection. Either a number indicating
a single trait or a function returning a vector of length nInd.}

\item{use}{select on genetic values (\code{gv}, default), estimated
breeding values (\code{ebv}), breeding values (\code{bv}),
or phenotypes (\code{pheno})}

\item{p}{the proportion of individuals selected}

\item{selectTop}{selects highest values if true.
Selects lowest values if false.}

\item{simParam}{an object of \code{\link{SimParam}}}

\item{...}{additional arguments if using a function for
trait}
}
\value{
Returns a numeric value
}
\description{
Calculates the usefulness criterion
}
\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=2, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
\dontshow{SP$nThreads = 1L}
SP$addTraitA(10)

#Create population
pop = newPop(founderPop, simParam=SP)

#Determine usefulness of population
usefulness(pop, simParam=SP)

#Should be equivalent to GV of best individual
max(gv(pop))

}
