% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quality_control.R
\name{quality_control}
\alias{quality_control}
\title{Quality Control of a Pollen Database}
\usage{
quality_control(data, int.window = 2, perc.miss = 20,
  ps.method = "percentage", result = "plot", th.day = 100,
  perc = 95, def.season = "natural", reduction = FALSE,
  red.level = 0.9, derivative = 5, man = 11, th.ma = 5,
  n.clinical = 5, window.clinical = 7, window.grains = 5,
  th.pollen = 10, th.sum = 100, type = "none",
  int.method = "lineal", ...)
}
\arguments{
\item{data}{A \code{data.frame} object including the general database where quality must be checked. This data.frame must include a first column in \code{Date} format and the rest of columns in \code{numeric} format belonging to each pollen type by column. It is not necessary to insert the missing gaps; the function will automatically detect them.}

\item{int.window}{A  \code{numeric (interger)}value bigger or equal to \code{1}. The argument specifies the number of days of each side of the start, peak or end date of the main pollen season which will be checked during the quality control. If any of these days has been interpolated, the current season will not pass the quality control. The \code{int.window} argument will be \code{2} by default.}

\item{perc.miss}{A \code{numeric (interger)} value between \code{0} and \code{100}. The argument specifies the maximal percentage of interpolated days which is allowed inside the main pollen season to pass the quality control. The \code{perc.miss} argument will be \code{20} by default.}

\item{ps.method}{A \code{character} string specifying the method applied to calculate the pollen season and the main parameters. The implemented methods that can be used are: \code{"percentage"}, \code{"logistic"}, \code{"moving"}, \code{"clinical"} or \code{"grains"}. A more detailed information about the different methods for defining the pollen season may be consulted in \code{\link{calculate_ps}} function. The \code{ps.method} argument will be \code{"percentage"} by default.}

\item{result}{A \code{character} string specifying the format of the results. Only \code{"plot"} or \code{"table"} available. If \code{"plot"}, graphical resume of the quality control will be plotted. If \code{"table"}, a \code{data.frame} will be created indicating the filters passed by each pollen type and season. Consult 'Return' for more information .The \code{result} argument will be \code{"plot"} by default.}

\item{th.day}{See \code{\link{calculate_ps}} for more details.}

\item{perc}{See \code{\link{calculate_ps}} for more details.}

\item{def.season}{See \code{\link{calculate_ps}} for more details.}

\item{reduction}{See \code{\link{calculate_ps}} for more details.}

\item{red.level}{See \code{\link{calculate_ps}} for more details.}

\item{derivative}{See \code{\link{calculate_ps}} for more details.}

\item{man}{See \code{\link{calculate_ps}} for more details.}

\item{th.ma}{See \code{\link{calculate_ps}} for more details.}

\item{n.clinical}{See \code{\link{calculate_ps}} for more details.}

\item{window.clinical}{See \code{\link{calculate_ps}} for more details.}

\item{window.grains}{See \code{\link{calculate_ps}} for more details.}

\item{th.pollen}{See \code{\link{calculate_ps}} for more details.}

\item{th.sum}{See \code{\link{calculate_ps}} for more details.}

\item{type}{See \code{\link{calculate_ps}} for more details.}

\item{int.method}{See \code{\link{calculate_ps}} for more details.}

\item{...}{Other arguments passed on to the pollen season calculation as specified in \code{\link{calculate_ps}} function.}
}
\value{
This function can return different results: \cr
\itemize{
\item If \code{result = "plot"}: Graphical resume of the Quality Control results showing the seasons of each pollen type and their quality (the risk assumed if they are included in further studies). The legend indicates the number of filter that have been unsuccessfully passed for each case. Object of class \code{\link[ggplot2]{ggplot}}. For graphical customization, see \code{\link[ggplot2]{ggplot}} function.
\item If \code{result = "table"}: \code{data.frame} with \code{logical} values for each pollen type and season. If \code{TRUE}, the filter has been successfully passed for this case. If FALSE, this case does not fit the minimal requirements of this filter.
}
}
\description{
Function to check the quality of an historical database of several pollen types.
}
\details{
Quality control is a relevant topic for aerobiology (Oteros et al., 2013). This function is another approach to improve the quality control management in the field. \cr\code{quality_control} function checks the quality of the pollen data of each pollen type and season. The filters applied by the function are: \cr
\itemize{
\item If the main pollen season (Galan et al., 2017) cannot be calculated according to \code{\link{calculate_ps}} function minimal requirements (lack of data for these pollen type and year). Filter named \code{"Complete"} in the \code{"quality_control"} \code{data.frame}.
\item If the start, end or peak date of the main pollen season has been interpolated or a day near to it (number of days specified by \code{int.window} argument). If a day near to these dates is missing, the selected date could not be the right one. Filters named \code{"Start"}, \code{"Peak"} and \code{"End"} in the \code{"quality_control"} \code{data.frame}.
\item The percentage of missing data inside the main pollen season. It calculates the number of days which have been interpolated by the algorithm and their percentage inside the main pollen season. If a high percentage of the main pollen season has been interpolated, the information of these season could not be reliable. Filter named \code{"Comp.MPS"} in the \code{"quality_control"} \code{data.frame}.
}
}
\examples{
data("munich_pollen")
quality_control(munich_pollen[,c(1:4)])
}
\references{
Galan, C., Ariatti, A., Bonini, M., Clot, B., Crouzy, B., Dahl, A., Fernandez_Gonzalez, D., Frenguelli, G., Gehrig, R., Isard, S., Levetin, E., Li, D.W., Mandrioli, P., Rogers, C.A., Thibaudon, M., Sauliene, I., Skjoth, C., Smith, M., Sofiev, M., 2017. Recommended terminology for aerobiological studies. Aerobiologia (Bologna). 293_295.

Oteros, J., Galan, C., Alcazar, P., & Dominguez_Vilches, E. (2013). Quality control in bio_monitoring networks, Spanish Aerobiology Network. Science of the Total Environment, 443, 559_565.
}
\seealso{
\code{\link{calculate_ps}}, \code{\link{interpollen}}, \code{\link[ggplot2]{ggplot}}, \code{\link[ggplot2]{ggsave}}
}
