% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lineups_data_adjustment.R
\name{lineups_data_adjustment}
\alias{lineups_data_adjustment}
\title{Lineups data adjustment}
\usage{
lineups_data_adjustment(df1)
}
\arguments{
\item{df1}{Should be a Data Frame}
}
\value{
The data frame obtained for the basic statistics of lineups will have the following format:
        \itemize{
                \item Point Guard (PG)
                \item Shooting Guard (SG)
                \item Small Forward (SF)
                \item Paint Forward (PF)
                \item Center (C)
                \item Games played (G)
                \item Games Started (GS)
                \item Minutes Played (MP)
                \item Field Goals Made (FG)
                \item Field Goals Attempted (FGA)
                \item Field Goals Percentage (FG%)
                \item Three Points Made (3P)
                \item Three Points Attempted (3PA)
                \item Three Points Percentage (3P\%)
                \item Two Points Made (2P)
                \item Two Points Attempted (2PA)
                \item Free Throw Made (FT)
                \item Offensive Rebounds (ORB)
                \item Defensive Rebounds (DRB)
                \item Total Rebounds (TRB)
                \item Assists (AST)
                \item Steals (STL)
                \item Blocks (BLK)
                \item Turnover (TOV)
                \item Personal Fouls (PF)
                \item Points (PTS)
                \item Plus (+)
                \item Minus (-)
                \item Plus Minus (+/-)
        }
For the extended statistics of the lineups it will have the same format as the basic statistics of the lineups but adding the statistics of the opponent against that lineups.
}
\description{
The function transform the statistics entered for later use in the rest of the functions that apply to lineup statistics.
}
\details{
\itemize{
                \item The data.frame must have the same columns and these represent the same as in the example.
                \item The function allows the transformation of the basic statistics of the lineups to which the shooting percentages, the total rebounds and the plus minus.
                \item The function allows the transformation of the extended statistics of the lineups to which the total rebounds and the plus minus.
        }
}
\examples{

df1 <- data.frame("PG"= c("James","Rondo"),"SG" = c("Green","Caruso"),
"SF" = c("Caldwell","Kuzma"), "PF" = c("Davis","Davis"),
"C" = c("Howard ","Howard"),"MP" = c(7,1), "FG " = c(4,0),
"FGA"  = c(7,0), "X3P" = c(0,0),"X3PA" = c(2,0),"X2P" = c(4,0),
"X2PA" = c(5,0),  "FT" = c(1,0), "FTA" = c(3,0),"ORB" = c(2,0),
"DRB" = c(5,0), "AST " = c(2,0), "STL " = c(1,0), "BLK " = c(0,0),
"TOV " = c(7,2), "PF" = c(1,0),  "PLUS" = c(9,0),"MINUS" = c(17,3))

lineups_data_adjustment(df1)

df1 <-  data.frame("PG" = c("James","Rondo"),"SG"= c("Green","Caruso"),
"SF" = c("Caldwell","Kuzma"), "PF" = c("Davis","Davis"),
"C" = c("Howard ","Howard"),"MP" = c(7,1), "FG " = c(6,0),
"OppFG " = c(6,0), "FGA " = c(10,0),"OppFGA " = c(9,0),
"X3P  " = c(2,0),"Opp3P  " = c(1,0),"X3PA " = c(4,0),
"Opp3PA  Ã§" = c(3,0),"X2P" = c(4,0),"Opp2P" = c(5,0),"X2PA " = c(6,0),
"Opp2PA" = c(8,0) , "FT " = c(0,0),"OppFT " = c(1,0), "FTA " = c(0,0),
"OppFTA" = c(1,0),"OppRB" = c(2,0),"OppOppRB" = c(1,0),"DRB" = c(4,0),
"OppDRB" = c(1,0),"AST " = c(5,0),"OppAST " = c(4,0),"STL" = c(1,0),
"OppSTL" = c(3,0),"BLK" = c(0,0),"OppBLK" = c(1,0),"TOppV" = c(5,2),
"OppTOppV" = c(3,2),"PF" = c(1,0),"OppPF" = c(3,0),"PLUS" = c(15,0),
"MINUS" = c(14,3))


lineups_data_adjustment(df1)

}
\author{
Fco Javier Cantero \email{fco.cantero@edu.uah.es}

Juan José Cuadrado \email{jjcg@uah.es}

Universidad de Alcalá de Henares
}
