% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{get.plotted.partial.cmas}
\alias{get.plotted.partial.cmas}
\title{Get info about the plotted partial CMAs.}
\usage{
get.plotted.partial.cmas(
  plot.type = c("baseR", "SVG")[1],
  suppress.warnings = FALSE
)
}
\arguments{
\item{plot.type}{Can be either "baseR" or "SVG" and specifies to which type of plotting
the mapping applies.}

\item{suppress.warnings}{\emph{Logical}, if \code{TRUE} don't show any
warnings.}
}
\value{
A \code{data.frame} that contains info about:
\itemize{
 \item the patient ID (\emph{pid}) to which the partial CMA belongs.
 \item the \emph{type} of partial CMA (see the help for plotting "complex"
 CMAs).
 \item the corners of the whole area covered by the partial CMA plot given as
 \emph{x.region.start}, \emph{y.region.start}, \emph{x.region.end} and
 \emph{y.region.end}.
 \item for each element of the partial CMA plot, its area as
 \emph{x.partial.start}, \emph{y.partial.start}, \emph{x.partial.end} and
 \emph{y.partial.end}.
}
Please note that this contains one row per partial CMA element (e.g., if
plotting stacked, one row for each rectangle).
}
\description{
Returns a \code{data.frame} where each row contains info about one plotted
partial CMA (partial CMAs make sense only for "complex" CMAs, i.e., per
episode and sliding windows).
}
\details{
This is intended for advanced users only.
}
