#' ighv_mus_df
#'
#' C57BL/6 germline IgH-V (heavy chain v-gene segments). When multiple alleles were present, the
#' first one was included. These names and sequences can be changed by
#' customized by changing this dataframe. Additionally, repeating elements
#' can give certain germline gene elements a larger probability of being used
#' during repertoire evolution.
#'
#' @format A data frame with 164 rows and 2 variables:
#' \describe{
#'   \item{gene}{The gene name}
#'   \item{seq}{The corresponding sequence}
#' }
#' @source IMGT
"ighv_mus_df"

#' ighd_mus_df
#'
#' C57BL/6 germline IgH-D (heavy chain d-gene segments). When multiple alleles were present, the
#' first one was included. These names and sequences can be changed by
#' customized by changing this dataframe. Additionally, repeating elements
#' can give certain germline gene elements a larger probability of being used
#' during repertoire evolution.
#'
#' @format A data frame with 27 rows and 2 variables:
#' \describe{
#'   \item{gene}{The gene name}
#'   \item{seq}{The corresponding sequence}
#' }
#' @source IMGT
"ighd_mus_df"

#' ighj_mus_df
#'
#' C57BL/6 germline IgH-J (heavy chain j-gene segments). When multiple alleles were present, the
#' first one was included. These names and sequences can be changed by
#' customized by changing this dataframe. Additionally, repeating elements
#' can give certain germline gene elements a larger probability of being used
#' during repertoire evolution.
#'
#' @format A data frame with 4 rows and 2 variables:
#' \describe{
#'   \item{gene}{The gene name}
#'   \item{seq}{The corresponding sequence}
#' }
#' @source IMGT
"ighj_mus_df"

#' ighv_hum_df
#'
#' human germline IgH-V (heavy chain v gene segments). When multiple alleles were present, the
#' first one was included. These names and sequences can be changed by
#' customized by changing this dataframe. Additionally, repeating elements
#' can give certain germline gene elements a larger probability of being used
#' during repertoire evolution.
#'
#' @format A data frame with 119 rows and 2 variables:
#' \describe{
#'   \item{gene}{The gene name}
#'   \item{seq}{The corresponding sequence}
#' }
#' @source IMGT
"ighv_hum_df"


#' ighd_hum_df
#'
#' human germline IgH-D (heavy chain d-gene segments). When multiple alleles were present, the
#' first one was included. These names and sequences can be changed by
#' customized by changing this dataframe. Additionally, repeating elements
#' can give certain germline gene elements a larger probability of being used
#' during repertoire evolution.
#'
#' @format A data frame with 37 rows and 2 variables:
#' \describe{
#'   \item{gene}{The gene name}
#'   \item{seq}{The corresponding sequence}
#' }
#' @source IMGT
"ighd_hum_df"


#' ighj_hum_df
#'
#' human germline IgH-V (heavy chain v-gene segments). When multiple alleles were present, the
#' first one was included. These names and sequences can be changed by
#' customized by changing this dataframe. Additionally, repeating elements
#' can give certain germline gene elements a larger probability of being used
#' during repertoire evolution.
#'
#' @format A data frame with 6 rows and 2 variables:
#' \describe{
#'   \item{gene}{The gene name}
#'   \item{seq}{The corresponding sequence}
#' }
#' @source IMGT
"ighj_hum_df"


#' igkv_hum_df
#'
#' human germline IgK-V (light chain kappa v-gene segments). When multiple alleles were present, the
#' first one was included. These names and sequences can be changed by
#' customized by changing this dataframe. Additionally, repeating elements
#' can give certain germline gene elements a larger probability of being used
#' during repertoire evolution.
#'
#' @format A data frame with 74 rows and 2 variables:
#' \describe{
#'   \item{gene}{The gene name}
#'   \item{seq}{The corresponding sequence}
#' }
#' @source IMGT
"igkv_hum_df"



#' igkj_hum_df
#'
#' human germline IgK-J (light chain kappa j-gene segments). When multiple alleles were present, the
#' first one was included. These names and sequences can be changed by
#' customized by changing this dataframe. Additionally, repeating elements
#' can give certain germline gene elements a larger probability of being used
#' during repertoire evolution.
#'
#' @format A data frame with 5 rows and 2 variables:
#' \describe{
#'   \item{gene}{The gene name}
#'   \item{seq}{The corresponding sequence}
#' }
#' @source IMGT
"igkj_hum_df"


#' igkv_mus_df
#'
#' mouse germline IgK-V (light chain kappa V-gene segments). When multiple alleles were present, the
#' first one was included. These names and sequences can be changed by
#' customized by changing this dataframe. Additionally, repeating elements
#' can give certain germline gene elements a larger probability of being used
#' during repertoire evolution.
#'
#' @format A data frame with 76 rows and 2 variables:
#' \describe{
#'   \item{gene}{The gene name}
#'   \item{seq}{The corresponding sequence}
#' }
#' @source IMGT
"igkv_mus_df"


#' igkj_mus_df
#'
#' mouse germline IgK-J (light chain kappa J-gene segments). When multiple alleles were present, the
#' first one was included. These names and sequences can be changed by
#' customized by changing this dataframe. Additionally, repeating elements
#' can give certain germline gene elements a larger probability of being used
#' during repertoire evolution.
#'
#' @format A data frame with 5 rows and 2 variables:
#' \describe{
#'   \item{gene}{The gene name}
#'   \item{seq}{The corresponding sequence}
#' }
#' @source IMGT
"igkj_mus_df"



#' iglv_hum_df
#'
#' human germline IgL-V (light chain lambda v-gene segments). When multiple alleles were present, the
#' first one was included. These names and sequences can be changed by
#' customized by changing this dataframe. Additionally, repeating elements
#' can give certain germline gene elements a larger probability of being used
#' during repertoire evolution.
#'
#' @format A data frame with 49 rows and 2 variables:
#' \describe{
#'   \item{gene}{The gene name}
#'   \item{seq}{The corresponding sequence}
#' }
#' @source IMGT
"iglv_hum_df"



#' iglj_hum_df
#'
#' human germline IgL-J (light chain lambda j-gene segments). When multiple alleles were present, the
#' first one was included. These names and sequences can be changed by
#' customized by changing this dataframe. Additionally, repeating elements
#' can give certain germline gene elements a larger probability of being used
#' during repertoire evolution.
#'
#' @format A data frame with 9 rows and 2 variables:
#' \describe{
#'   \item{gene}{The gene name}
#'   \item{seq}{The corresponding sequence}
#' }
#' @source IMGT
"iglj_hum_df"


#' iglv_mus_df
#'
#' mouse germline IgL-V (light chain lambda V-gene segments). When multiple alleles were present, the
#' first one was included. These names and sequences can be changed by
#' customized by changing this dataframe. Additionally, repeating elements
#' can give certain germline gene elements a larger probability of being used
#' during repertoire evolution.
#'
#' @format A data frame with 12 rows and 2 variables:
#' \describe{
#'   \item{gene}{The gene name}
#'   \item{seq}{The corresponding sequence}
#' }
#' @source IMGT
"iglv_mus_df"


#' iglj_mus_df
#'
#' mouse germline IgL-J (light chain lambda J-gene segments). When multiple alleles were present, the
#' first one was included. These names and sequences can be changed by
#' customized by changing this dataframe. Additionally, repeating elements
#' can give certain germline gene elements a larger probability of being used
#' during repertoire evolution.
#'
#' @format A data frame with 7 rows and 2 variables:
#' \describe{
#'   \item{gene}{The gene name}
#'   \item{seq}{The corresponding sequence}
#' }
#' @source IMGT
"iglj_mus_df"



#' one_spot_df
#'
#' WRC hotspot mutations taken from Yaari et al., Frontiers in Immunology, 2013.
#' These include only the mutations following the WRC pattern,
#' where W equals A or T and R equals A or G). Custom mutation hotspots can be supplied
#' by modifying this dataframe. Repeating particular hotspot entries allows
#' for the hotspot to mutate more than one time per SHM event.
#'
#' @format A data frame with 32 rows and 6 variables:
#' \describe{
#'   \item{pattern}{Character array where each entry corresponds to a 5 base motif. The
#'   mutation probabilities correspond to the middle nucleotide in each 5mer.}
#'   \item{toA}{The probability for the middle nucleotide in "pattern" to mutate to an adenine}
#'   \item{toC}{The probability for the middle nucleotide in "pattern" to mutate to an cytosine}
#'   \item{toG}{The probability for the middle nucleotide in "pattern" to mutate to an guanine}
#'   \item{toT}{The probability for the middle nucleotide in "pattern" to mutate to an thymine}
#'   \item{Source}{The origin of how this motif was discovered. Either Inferred or Experimental}
#' }
#' @source Yaari et al., Frontiers in Immunology, 2013
"one_spot_df"


#' hotspot_df
#'
#' Hotspot mutations taken from Yaari et al., Frontiers in Immunology, 2013.
#' This contains transition probabilities for all 5mer combinations based
#' on high throughput sequencing data. The transition probabilities are for
#' the middle nucleotide in each 5mer set. This can be customized by changing the genes
#' and sequences. Custom mutation hotspots can be supplied
#' by modifying this dataframe. Repeating particular hotspot entries allows
#' for the hotspot to mutate more than one time per SHM event.
#'
#'  @format A data frame with 1024 rows and 6 variables:
#' \describe{
#'   \item{pattern}{Character array where each entry corresponds to a 5 base motif. The
#'   mutation probabilities correspond to the middle nucleotide in each 5mer.}
#'   \item{toA}{The probability for the middle nucleotide in "pattern" to mutate to an adenine}
#'   \item{toC}{The probability for the middle nucleotide in "pattern" to mutate to an cytosine}
#'   \item{toG}{The probability for the middle nucleotide in "pattern" to mutate to an guanine}
#'   \item{toT}{The probability for the middle nucleotide in "pattern" to mutate to an thymine}
#'   \item{Source}{The origin of how this motif was discovered. Either Inferred or Experimental}
#' }
#' @source Yaari et al., Frontiers in Immunology, 2013
"hotspot_df"

