% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi_indices.R
\name{multi.indices}
\alias{multi.indices}
\title{Produce multiple indices}
\usage{
multi.indices(directory = getwd(), crop = "n", ext2crop = "none",
  op_directory = directory, arvi = 0, gamma = 1, gemi = 0, gvmi = 0,
  msavi = 0, ndbi = 0, ndvi = 1, ndwi = 0, pavi = 0, all = 0)
}
\arguments{
\item{ext2crop, crop, directory}{Same as mentioned in \code{\link[ASIP]{arvi}}.}

\item{op_directory}{Specify the output directory <within double quotes>. By default the input satellite image directory will be selected as the output directory.}

\item{arvi}{This product won't be produced by default. To produce this product, assign value 1.
This product is same as that of the output from \code{\link[ASIP]{arvi}}. Only difference is, this function intakes
already produced TOA bands instead of creating new TOA bands from source satellite image bands.}

\item{gamma}{Defined in \code{\link[ASIP]{arvi}}.}

\item{gemi}{This product won't be produced by default. To produce this product, assign value 1.
This product is same as that of the output from \code{\link[ASIP]{gemi}}. Only difference is, this function intakes
already produced TOA bands instead of creating new TOA bands from source satellite image bands.}

\item{gvmi}{This product won't be produced by default. To produce this product, assign value 1.
This product is same as that of the output from \code{\link[ASIP]{gvmi}}. Only difference is, this function intakes
already produced TOA bands instead of creating new TOA bands from source satellite image bands.}

\item{msavi}{This product won't be produced by default. To produce this product, assign value 1.
This product is same as that of the output from \code{\link[ASIP]{msavi}}. Only difference is, this function intakes
already produced TOA bands instead of creating new TOA bands from source satellite image bands.}

\item{ndbi}{This product won't be produced by default. To produce this product, assign value 1.
This product is same as that of the output from \code{\link[ASIP]{ndbi}}. Only difference is, this function intakes
already produced TOA bands instead of creating new TOA bands from source satellite image bands.}

\item{ndvi}{This product will be produced by default. To disable this product, assign value 0.
This product is same as that of the output from \code{\link[ASIP]{ndvi}}. Only difference is, this function intakes
already produced TOA bands instead of creating new TOA bands from source satellite image bands.}

\item{ndwi}{This product won't be produced by default. To produce this product, assign value 1.
This product is same as that of the output from \code{\link[ASIP]{ndwi}}. Only difference is, this function intakes
already produced TOA bands instead of creating new TOA bands from source satellite image bands.}

\item{pavi}{This product won't be produced by default. To produce this product, assign value 1.
This product is same as that of the output from \code{\link[ASIP]{pavi}}. Only difference is, this function intakes
already produced TOA bands instead of creating new TOA bands from source satellite image bands.}

\item{all}{If you wish to produce all the indices, assign value 1.}
}
\value{
Each bands selected will produce corresponding image in *.tif format in the input directory.
}
\description{
This function is designed to produce multiple indices directly. The source satellite image bands will be converted Top of Atmosphere (TOA)
reflectance prior to do the indices production.
}
\note{
1. This function followed by \code{\link[ASIP]{multi.indices}} is recommended only if user is intended to produce multiple indices
like ndvi & gemi other than running seperate function for each product to save processing time and resources.

Other important notes are mentioned in \code{\link[ASIP]{custom.eqn}}.
}
\examples{
library (raster)
library (rgdal)
# Finding the path of the sample satellite image directory.
# User may define paths directly like "/home/ur_folder" or "C:/ur_folder"
path <- system.file ("TM_sample", package = "ASIP")
shapefil <- paste0 (path, "/test.shp")
multi.indices (path, crop = "f", ext2crop = shapefil, msavi =1, ndvi = 0)
}
