% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/align_taxa.R
\name{align_taxa}
\alias{align_taxa}
\title{Find taxonomic alignments for a list of names to a version of the Australian Plant Census (APC) through standardizing formatting and checking for spelling issues}
\usage{
align_taxa(
  original_name,
  output = NULL,
  full = FALSE,
  resources = load_taxonomic_resources(),
  fuzzy_abs_dist = 3,
  fuzzy_rel_dist = 0.2,
  fuzzy_matches = TRUE,
  imprecise_fuzzy_matches = FALSE,
  APNI_matches = TRUE,
  identifier = NA_character_
)
}
\arguments{
\item{original_name}{A list of names to query for taxonomic alignments.}

\item{output}{(optional) The name of the file to save the results to.}

\item{full}{Parameter to determine how many columns are output}

\item{resources}{the taxonomic resources used to align the taxa names. Loading this can be slow,
so call \code{\link{load_taxonomic_resources}} separately to greatly speed this function up and pass the resources in.}

\item{fuzzy_abs_dist}{The number of characters allowed to be different for a fuzzy match.}

\item{fuzzy_rel_dist}{The proportion of characters allowed to be different for a fuzzy match.}

\item{fuzzy_matches}{Fuzzy matches are turned on as a default. The relative and absolute distances allowed for fuzzy matches to species and infraspecific taxon names are defined by the parameters \code{fuzzy_abs_dist} and \code{fuzzy_rel_dist}}

\item{imprecise_fuzzy_matches}{Imprecise fuzzy matches are turned off as a default.}

\item{APNI_matches}{Name matches to the APNI (Australian Plant Names Index) are turned off as a default.}

\item{identifier}{A dataset, location or other identifier, which defaults to NA.}
}
\value{
A tibble with columns that include original_name, aligned_name, taxonomic_dataset, taxon_rank, aligned_reason, alignment_code. See Details
}
\description{
This function uses Australian Plant Census (APC) & the Australian Plant Name Index (APNI) to find taxonomic alignments for a list of names.
}
\details{
\itemize{
\item original_name: the original plant name input.
\item aligned_name: the original plant name after the function standardise_names has standardised the syntax of infraspecific taxon designations.
\item taxonomic_dataset: the source of the aligned names (APC or APNI).
\item taxon_rank: the taxonomic rank of the aligned name.
\item aligned_reason: the explanation of a specific taxon name alignment (from an original name to an aligned name).
\item alignment_code: a code that accompanies the aligned_reason, indicating the relative sequence of the match during the alignment process.
\item cleaned_name: original name with punctuation and infraspecific taxon designation terms standardised by the function standardise_names; streamlines exact matches.
\item stripped_name: cleaned name with punctuation and infraspecific taxon designation terms removed by the function strip_names; improves fuzzy matches.
\item stripped_name2: cleaned name with punctuation, infraspecific taxon designation terms, and other filler words removed by the function strip_names_2; required for matches to \verb{first two word} and \verb{first three words}.
\item trinomial: the first three words in \code{stripped_name2}, required for matches that ignore all other text in the original_name; improves phrase name matches.
\item binomial: the first two words in \code{stripped_name2}, required for matches that ignore all other text in the original_name; improves phrase name matches.
\item genus: the first two words in \code{cleaned_name}; required for genus-rank matches and reprocessing of genus-rank names.
\item fuzzy_match_genus: fuzzy match of genus column to best match among APC-accepted names; required for fuzzy matches of genus-rank names.
\item fuzzy_match_genus_known: fuzzy match of genus column to best match among APC-known names, only considering different matches to those documented under APC-accepted genera; required for fuzzy matches of genus-rank names.
\item fuzzy_match_genus_APNI: fuzzy match of genus column to best match among APNI names, only considering different matches to those documented under APC-accepted and APC-known genera; required for fuzzy matches of genus-rank names.
\item fuzzy_match_cleaned_APC: fuzzy match of stripped_name to APC-accepted names; created for yet-to-be-aligned names at the match step 07a in the function \code{match_taxa}.
\item fuzzy_match_cleaned_APC_known: fuzzy match of stripped_name to APC-known names; created for yet-to-be-aligned names at the match step 07b in the function \code{match_taxa}.
\item fuzzy_match_cleaned_APC_imprecise: imprecise fuzzy match of stripped_name to APC-accepted names; created for yet-to-be-aligned names at the match step 10a in the function \code{match_taxa}.
\item fuzzy_match_cleaned_APC_known_imprecise: imprecise fuzzy match of stripped_name to APC-accepted names; created for yet-to-be-aligned names at the match step 10b in the function \code{match_taxa}.
\item fuzzy_match_binomial: fuzzy match of binomial column to best match among APC-accepted names; created for yet-to-be-aligned names at match step 15a in the function \code{match_taxa}.
\item fuzzy_match_binomial_APC_known: fuzzy match of binomial column to best match among APC-known names; created for yet-to-be-aligned names at match step 15a in the function \code{match_taxa}.
\item fuzzy_match_trinomial: fuzzy match of trinomial column to best match among APC-accepted names; created for yet-to-be-aligned names at match step 16a in the function \code{match_taxa}.
\item fuzzy_match_trinomial_known: fuzzy match of trinomial column to best match among APC-known names; created for yet-to-be-aligned names at match step 16b in the function \code{match_taxa}.
\item fuzzy_match_cleaned_APNI: fuzzy match of stripped_name to APNI names; created for yet-to-be-aligned names at the match step 16a in the function \code{match_taxa}.
\item fuzzy_match_cleaned_APNI_imprecise: imprecise fuzzy match of stripped_name to APNI names; created for yet-to-be-aligned names at the match step 17a in the function \code{match_taxa}.
}
}
\examples{
\donttest{align_taxa(c("Poa annua", "Abies alba"))}

}
\seealso{
\code{\link{load_taxonomic_resources}}

Other taxonomic alignment functions: 
\code{\link{create_taxonomic_update_lookup}()},
\code{\link{update_taxonomy}()}
}
\concept{taxonomic alignment functions}
