% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{tree_enrico}
\alias{tree_enrico}
\title{Tree-level data of 16 forest stands in Lower Saxony, Germany}
\format{
A \code{data.frame} of 2813 trees on 16 plots. Tree coordinates are
stored as 'simple feature column' (see the \code{\link[sf:sf]{sf}}-package for more
details):

\describe{

\item{id_tree}{Unique tree id.}

\item{id_plot}{Plot id's}

\item{species}{Name of the tree species}

\item{position}{Does the tree stand in the core plot ('plot') or in the 10 m
buffer zone around the core plot ('buffer').}

\item{dbh}{Diameter at breast height (1.3 m) in cm.}

\item{height}{Top height of the tree in m. Estimated with a stand height
curve.}

\item{crown_radius_95}{Expected 95 \% quantile of the crown radius of a tree
of this species and diameter. Estimated according to allometric equations
(Pretzsch et al. 2015)}

\item{crown_radius_95}{Expected median of the crown radius of a tree of this
species and diameter. Estimated according to allometric equations (Pretzsch
et al. 2015)}

\item{tree_geometry}{A \code{sfc_POINT}-column specifying tree coordinates
relative to the plot center in meter.}

}
}
\usage{
tree_enrico
}
\description{
This dataset contains tree-level data from the Enrico-project from 16 mixed
forest stands in Lower Saxony, Germany.
}
\references{
{ Ammer, Christian; Annighoefer, Peter; Balkenhol, Niko; Hertel,
 Dietrich; Leuschner, Christoph; Polle, Andrea; Lamersdorf, Norbert; Scheu,
 Stefan; Glatthorn, Jonas (2020): RTG 2300 - Enrichment of European beech
 forests with conifers. PANGAEA, https://doi.org/10.1594/PANGAEA.925228}

{ Pretzsch, H., Biber, P., Uhl, E., Dahlhausen, J., Roetzer, T., Caldentey,
 J., Koike, T., van Con, T., Chavanne, A., Seifert, T., Du Toit, B., Farnden,
 C., Pauleit, S., 2015. Crown size and growing space requirement of common
 tree species in urban centres, parks, and forests. Urban Forestry & Urban
 Greening 14 (3), 466-479.}
}
\keyword{datasets}
