# ==================================================================== #
# TITLE                                                                #
# Antimicrobial Resistance (AMR) Analysis                              #
#                                                                      #
# SOURCE                                                               #
# https://github.com/msberends/AMR                                     #
#                                                                      #
# LICENCE                                                              #
# (c) 2018-2020 Berends MS, Luz CF et al.                              #
#                                                                      #
# This R package is free software; you can freely use and distribute   #
# it for both personal and commercial purposes under the terms of the  #
# GNU General Public License version 2.0 (GNU GPL-2), as published by  #
# the Free Software Foundation.                                        #
#                                                                      #
# We created this package for both routine data analysis and academic  #
# research and it was publicly released in the hope that it will be    #
# useful, but it comes WITHOUT ANY WARRANTY OR LIABILITY.              #
# Visit our website for more info: https://msberends.github.io/AMR.    #
# ==================================================================== #

context("skewness.R")

test_that("skewness works", {
  skip_on_cran()
  expect_equal(skewness(example_isolates$age),
               -0.8958019,
               tolerance = 0.00001)
  expect_equal(unname(skewness(data.frame(example_isolates$age))),
               -0.8958019,
               tolerance = 0.00001)
  expect_equal(skewness(matrix(example_isolates$age)),
               -0.8958019,
               tolerance = 0.00001)
})
