% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{fftshift}
\alias{fftshift}
\title{fftshift}
\usage{
fftshift(x, dim = -1)
}
\arguments{
\item{x}{square matrix input with odd number of rows and columns}

\item{dim}{shift method. See 'Details'.}
}
\value{
Shifted matrix.
}
\description{
Rearranges a 2D Fourier transform x by shifting the zero-frequency component
to the center of the matrix.
}
\details{
By default, \code{dim=-1}, swaps the first quadrant of x with the
third, and the second quadrant with the fourth. If \code{dim=1}, swaps rows 1
to middle with rows (middle+1) to end. If \code{dim=2}, swaps columns 1
to middle with columns (middle+1) to end. If \code{dim=3}, reverse fftshift.
}
\examples{
library(AIUQ)

(m <- matrix(0:8,3,3))
fftshift(m)

}
\author{
\packageAuthor{AIUQ}
}
\keyword{internal}
