% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{anisotropic_fbm_ou_particle_intensity}
\alias{anisotropic_fbm_ou_particle_intensity}
\title{Simulate 2D particle trajectory follows anisotropic fBM plus OU}
\usage{
anisotropic_fbm_ou_particle_intensity(
  pos0,
  M,
  len_t,
  sigma_fbm,
  sigma_ou,
  H,
  rho
)
}
\arguments{
\item{pos0}{initial position for \code{M} particles, matrix with dimension M by 2}

\item{M}{number of particles}

\item{len_t}{number of time steps}

\item{sigma_fbm}{distance moved per time step in fractional Brownian Motion
in x, y-directions, a vector of length 2}

\item{sigma_ou}{distance moved per time step in Ornstein–Uhlenbeck process
in x, y-directions, a vector of length 2}

\item{H}{Hurst parameter of fractional Brownian Motion in x, y-directions,
a vector of length 2 with values between 0 and 1}

\item{rho}{correlation between successive step and previous step in OU process
in x, y-directions, a vector of length 2 with values between 0 and 1}
}
\value{
Position matrix with dimension \code{M}\eqn{\times}{\%\times}\code{len_t}
by 2 for particle trajectory. The first \code{M} rows being the initial position
\code{pos0}.
}
\description{
Simulate 2D particle trajectory follows anisotropic fraction Brownian
Motion(fBM) plus a Ornstein–Uhlenbeck(OU) process for \code{M} particles,
with different step sizes in x, y-directions.
}
\examples{
library(AIUQ)
M = 10
len_t = 50
sigma_fbm = c(2,1)
H = c(0.3,0.4)
sigma_ou = c(2,2.5)
rho = c(0.95,0.9)
pos0 = matrix(100/8+0.75*100*runif(M*2),nrow=M,ncol=2)

pos = anisotropic_fbm_ou_particle_intensity(pos0=pos0, M=M, len_t=len_t,
  sigma_fbm=sigma_fbm, sigma_ou=sigma_ou, H=H, rho=rho)
}
\author{
\packageAuthor{AIUQ}
}
\keyword{internal}
