% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Read_Raw.R
\name{read_AG_raw}
\alias{read_AG_raw}
\title{File reading function for primary accelerometer files}
\usage{
read_AG_raw(file, output_window_secs = 1, calibrate = FALSE,
  verbose = FALSE, skip = 10, block = FALSE, return_raw = FALSE, ...)
}
\arguments{
\item{file}{A character scalar giving path to primary accelerometer file}

\item{output_window_secs}{the desired epoch length; defaults to one second}

\item{calibrate}{logical. Perform autocalibration using \link[GGIR]{g.calibrate}}

\item{verbose}{A logical scalar: Print processing updates?}

\item{skip}{Header length: Number of rows to skip when reading the file}

\item{block}{logical. Should file be read in blocks? Will be automatically
invoked if file is larger than 2 GB.}

\item{return_raw}{logical. Return raw triaxial data?}

\item{...}{Arguments passed to \code{read.csv} in
\code{\link{check_columns}}}
}
\value{
A dataframe giving processed raw data from the primary accelerometer
  in the specified epoch length
}
\description{
File reading function for primary accelerometer files
}
\examples{
raw_file <- system.file(
  "extdata",
  "exampleRAW.csv",
  package = "AGread"
)

## suppress messages that indicate truncation when sampling
## rate and output window don't line up
AG_RAW <- suppressMessages(
  read_AG_raw(raw_file)
)
head(AG_RAW)

}
