% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/admm.bp.R
\name{admm.bp}
\alias{admm.bp}
\title{Basis Pursuit}
\usage{
admm.bp(A, b, xinit = NA, rho = 1, alpha = 1, abstol = 1e-04,
  reltol = 0.01, maxiter = 1000)
}
\arguments{
\item{A}{an \eqn{(m \times n)} regressor matrix}

\item{b}{a length-\eqn{m} response vector}

\item{xinit}{a length-\eqn{n} vector for initial value}

\item{rho}{an augmented Lagrangian parameter}

\item{alpha}{an overrelaxation parameter in [1,2]}

\item{abstol}{absolute tolerance stopping criterion}

\item{reltol}{relative tolerance stopping criterion}

\item{maxiter}{maximum number of iterations}
}
\value{
a named list containing \describe{
\item{x}{a length-\eqn{n} solution vector}
\item{history}{dataframe recording iteration numerics. See the section for more details.}
}
}
\description{
For an underdetermined system, Basis Pursuit
aims to find a sparse solution that solves
\deqn{min_x ~  \|x\|_1 \quad \textrm{s.t} \quad Ax=b}
which is a relaxed version of strict non-zero support finding problem.
The implementation is borrowed from Stephen Boyd's
\href{https://web.stanford.edu/~boyd/papers/admm/basis_pursuit/basis_pursuit.html}{MATLAB code}.
}
\section{Iteration History}{

When you run the algorithm, output returns not only the solution, but also the iteration history recording
following fields over iterates,
\describe{
\item{objval}{object (cost) function value}
\item{r_norm}{norm of primal residual}
\item{s_norm}{norm of dual residual}
\item{eps_pri}{feasibility tolerance for primal feasibility condition}
\item{eps_dual}{feasibility tolerance for dual feasibility condition}
}
In accordance with the paper, iteration stops when both \code{r_norm} and \code{s_norm} values
become smaller than \code{eps_pri} and \code{eps_dual}, respectively.
}

\examples{
## generate sample data
n = 30;
m = 10;
A = matrix(rnorm(n*m), nrow=m);

x = matrix(rep(0,n))
x[c(3,6,21),] = rnorm(3)
b = A\%*\%x

## run example
output = admm.bp(A, b)

## report convergence plot
niter  = length(output$history$s_norm)
par(mfrow=c(1,3))
plot(1:niter, output$history$objval, "b", main="cost function")
plot(1:niter, output$history$r_norm, "b", main="primal residual")
plot(1:niter, output$history$s_norm, "b", main="dual residual")

}
