% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores_ph.R
\name{compute_ph_y_bp__sys_nm}
\alias{compute_ph_y_bp__sys_nm}
\title{Compute "Blood Pressure [Youth] (Systolic): Number missing"}
\usage{
compute_ph_y_bp__sys_nm(data, name = "ph_y_bp__sys_nm", combine = TRUE)
}
\arguments{
\item{data}{tbl, Dataframe containing the columns to be summarized.}

\item{name}{character, Name of the new column to be created. Default is
the name in description, but users can change it.}

\item{combine}{logical, If \code{TRUE}, the summary score will be appended to
the input data frame. If \code{FALSE}, the summary score will be returned as a
separate data frame.}
}
\value{
tbl. The input data frame with the summary score appended as
a new column.
}
\description{
Computes the summary score \code{ph_y_bp__sys_nm}
Blood Pressure [Youth] (Systolic): Number missing
\itemize{
\item \emph{Summarized variables:}
\itemize{
\item \code{ph_y_bp__sys__r01_001}
\item \code{ph_y_bp__sys__r01_002}
\item \code{ph_y_bp__sys__r01_003}
\item \code{ph_y_bp__sys__r02_001}
\item \code{ph_y_bp__sys__r02_002}
\item \code{ph_y_bp__sys__r03_001}
\item \code{ph_y_bp__sys__r03_002}
}
\item \emph{Excluded values:} none
}
\subsection{Calculation}{

There are at most 3 possible rounds of measurements,
and the calculation is as follows:
\itemize{
\item if round 3 is available, use it, otherwise use round 2,
otherwise use round 1
\item for round 3 and 2, there are at most 2 measurements
\item for round 1, there are at most 3 measurements:
\itemize{
\item participants with 3 measurements, and 0 missing, nm = 0
\item participants with 2 measurements, and 1 missing, nm = 1 - 1 = 0
\item participants with 1 measurement, and 2 missing, nm = 2 - 1 = 1
\item participants with 0 measurements, and 3 missing, nm = 3 - 1 = 2
}
}
}
}
\examples{
\dontrun{
compute_ph_y_bp__sys_nm(data) |>
  select(
    all_of(c("ph_y_bp__sys_nm", vars_ph_y_bp__sys))
  )
}
}
\seealso{
\code{\link[=compute_ph_y_bp__sys_mean]{compute_ph_y_bp__sys_mean()}}
}
