/*************************************************************************************
/ C2R-Test.c
/  This is a driver for testing the output routines in C2R.h
/  Those routines write [parts of] an R- or S-language compatible
/  output object.
/  This program generates some dummy data and invokes those routines.
/  Code translated from Mike Prager's Fortran to C by Andi Stephens
****************************************************************************************/

#include "C2R.h"

// Globals

#define nyr 6
#define nage 5

    int i, j, iyr[nyr], iage[nage];         // iyr and iage are integer vectors
    double vec1[nyr], vec2[nyr];            // v1 and v2 are real vectors
    double *matrix[nyr];                    // matrix is array of pointers to real arrays
    char *colnames[nage], *rownames[nyr];   // arrays of string pointers
    int *mv_mat[nyr];                       // missing-value matrix
    int mv_vec[nyr];                        // missing-value vector

int main() {

    // Fill the year and age vectors.
    for (i=0; i < nyr; i++) {
        iyr[i] = 1990 + i;
    }
    for (j=0; j < nage; j++) {
        iage[j] = j+1;
    }

    // Generate column names
    for (i=0; i < nage; i++) {
        // Allocate storage for the string
        colnames[i] = (char *)malloc(sizeof(r_name));
        sprintf(colnames[i], "Var%d", i+1);
    }

    // Generate row names
    for (j=0; j < nyr; j++) {
        // Allocate storage for the string
        rownames[j] = (char *)malloc(sizeof(r_name));
        sprintf(rownames[j], "Year%d", j+1);
    }

    // Initialize missing-value vector and matrix.
    for (i=0; i < nyr; i++) {
        mv_vec[i] = FALSE;
        // Allocate storage space for arrays of logical
        // values.  Matrix is nyr x nage in size.
        mv_mat[i] = (int *)malloc(nage * sizeof(int));
        for (j=0; j < nage; j++) {
            mv_mat[i][j] = FALSE;
        }
    }

    // Assign NAs in a few places.
    mv_mat[1][2] = TRUE;
    mv_mat[3][4] = TRUE;
    mv_vec[5] = TRUE;

    // Pre-fill the real arrays with random numbers
//    srand(time(NULL));
//    for (i=0; i < nyr; i++) {
//        // Allocate storage space for arrays of real
//        // values.  Matrix is nyr x nage in size.
//        matrix[i] = (double *)malloc(nage * sizeof(double));
//        vec1[i] = rand();
//        vec2[i] = rand();
//        for (j=0; j < nage; j++) {
//            matrix[i][j] = rand();
//        }
//    }

    // Pre-fill the real arrays identifiable (real) values
    for (i=0; i < nyr; i++) {
        // Allocate storage space for arrays of real
        // values.  Matrix is nyr x nage in size.
        matrix[i] = (double *)malloc(nage * sizeof(double));
        vec1[i] = i + 0.3;
        vec2[i] = i + 1.3;
        for (j=0; j < nage; j++) {
            matrix[i][j] = j + i + 0.3;
        }
    }

    // Now write an R object that can be read with dget("c2r-test.rdat")
    // Open the output file.  Args are max level, max components,
    // and floating-point precision.  If 0, accept default value.
    open_r_file("test-c2r.rdat", 0,0,2);

    // Write the INFO object : date is automatically inserted.
    open_r_info_list("info");
        wrt_r_info_item("Author", "Andi Stephens");
        wrt_r_info_item("Species", "sarcastic fringehead");
        wrt_r_info_item("Model", "CAA.v2.3");
    close_r_info_list("Units.Len", "mm");

    // Write a floating-point VECTOR
    open_r_vector("Vector_1");
        for (i=0; i < nage; i++) {
            wrt_r_item(rownames[i], "%f", vec1[i]);
        }
    wrt_r_item(rownames[i], "%f LAST", vec1[i]);

    // Write a MATRIX object with character row names and column names
    wrt_r_matrix("Random.matrix", "%f Rn Cn", nyr, nage, matrix, rownames, colnames);

    // Write a DATA FRAME object.  Mix column types: integer,
    // floating-point, character-string.  This illustrates the
    // difference between matrices and dataframes.
    open_r_df("Timeseries");
        wrt_r_df_col("Integers", "%d", nyr, iyr);
        wrt_r_df_col("Float1", "%f", nyr, vec1);
        wrt_r_df_col("Strings", "%s", nyr, rownames);
    wrt_r_df_col("Float2", "%f NA Rn LAST", nyr, vec2, mv_vec, rownames); //LAST flag

    // Write a LIST object containing a matrix and a vector.
    open_r_list("Two.Things");
        wrt_r_matrix("Random.matrix", "%f NA Ri Ci", nyr, nage, matrix, mv_mat, iyr, iage);
        // Write a VECTOR object
        open_r_vector("Int.vector");
            wrt_r_item("Int1", "%d", 100);
            wrt_r_item("Int2", "%d", 12);
            wrt_r_item("Int3", "NA"); // Missing value flag
        wrt_r_item("Int4", "%d LAST", -27); // LAST flag
   close_r_list();

    // Close the file
    wrt_r_comment("Calling close_r_file -- last call in program.");
    close_r_file();
    return;

}// END main

