\name{char.poly.root}
\title{Compute the Roots of the Characteristic Polynomial}
\usage{
char.poly.root (nn, eigen = FALSE, abs = TRUE)
}
\alias{char.poly.root}
\alias{char.poly.root.ffnet.ts}
\arguments{
  \item{nn}{An object returned by \code{\link{ffnet.ts}}.}
  \item{eigen}{a logical indicating whether the roots of the
    characteristic polynomial or the eigenvalues of the companion matrix
    are returned.}
  \item{abs}{a logical indicating whether absolute values or complex
    values are returned.} 
}
\description{
  A generic procedure to compute the roots of the characteristic
  polynomial of a time series model. 
  
  \code{char.poly.root.ffnet.ts} treats neural network time series
  models.
}
\details{
  The roots of the characteristic polynomial are computed via the
  eigenvalues of the companion matrix. The eigenvalues are just the
  reverse roots of the characteristic polynomial plus all the zero
  eigenvalues.

  The characteristic polynomial is defined as one minus the lag operator
  polynomial of the autoregressive part of the model.
}
\value{
  A real or complex vector containing the roots or the eigenvalues.
}
\references{
  H. Luetkepohl (1991): \emph{Introduction to Multiple Time Series
  Analysis}, Springer, Berlin.
}
\author{A. Trapletti}
\seealso{
  \code{\link{ffnet.ts}}
}
\examples{
n <- 500
e <- rnorm (n)  # Generate AR(1) process
x <- double (n)
x[1] <- rnorm (1)
for (i in 2:n)
{
  x[i] <- 0.4*x[i-1]+e[i]
}
x <- ts(x)

nn <- ffnet (x, lag=1, trace="NO")
char.poly.root (nn, eigen = T)
}
\keyword{neural, ts}


