// Copyright (C) 1997-1999  Adrian Trapletti
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

//
// ffnet user interface for R
//


#include "linal.hh"
#include "neuro.hh"


extern "C" {

  void *R_callback;

  void R_ffnet_predict (double* X, long* XDIM, double* Y, long* YDIM, long* NHID, long* NOUT,
			int* HID_T, int* OUT_T, int* SHORT_C, double* W, long* NW)
  {
    vec w(W,*NW);
    mat x(X,XDIM[0],XDIM[1]);
    mat y;
    ffnet nn (x.columns(), *NHID, *NOUT, *HID_T, *OUT_T, *SHORT_C);
    
    nn.set_weights (w);
    y = nn.predict (x);
    mat2Rmat (y, Y);
  }
  
  void R_ffnet_train (double* X, long* XDIM, double* Y, long* YDIM, long* NHID, 
		      int* HID_T, int* OUT_T, int* SHORT_C, int* ERRF, int* REG, 
		      double* REG_C, int* OPT, int* BATCH, int* TRACE,
		      int* ITMAX, double* TOL, int* EPOCH, int* ITEPOCH, 
		      double* ETA, double* ALPHA, double* TEMP, int* ITTEMP,
		      double* W, long* NW, int* FW, long* NFW, double* errv,
		      double* H, long* HDIM, void* R_call)
  {
    long i;
    estim_proc ep; 
    vec w(W,*NW);
    intset fw(*NW);
    mat x(X,XDIM[0],XDIM[1]), y(Y,YDIM[0],YDIM[1]), h;
    ffnet nn (x.columns(), *NHID, y.columns(), *HID_T, *OUT_T, *SHORT_C);

    if (*BATCH)
    {
      if ((*OPT == STPDSC) || (*OPT == FRPRMN) || (*OPT == DFPMIN))
	ep.init (*OPT, *TRACE, *ITMAX, *TOL);
      else if (*OPT == GRDDSC)
	ep.init (*OPT, *TRACE, *ITMAX, *TOL, *ETA, *ALPHA);
      else if ((*OPT == SANN) || (*OPT == NRSANN))
	ep.init (*OPT, *TRACE, *ITMAX, *ITTEMP, *TEMP);
    }
    else
    {
      if ((*OPT == STPDSC) || (*OPT == FRPRMN) || (*OPT == DFPMIN))
	ep.init (*OPT, *TRACE, *ITMAX, *TOL, *EPOCH, *ITEPOCH);
      else if (*OPT == GRDDSC)
	ep.init (*OPT, *TRACE, *ITMAX, *TOL, *ETA, *ALPHA, *EPOCH, *ITEPOCH);
    }
    nn.set_weights (w);
    R_callback = R_call;
    if (*NFW > 0)
    {
      for (i=0; i<*NFW; i++)
	fw.insert (FW[i]);
      (*errv) = nn.train (x, y, fw, *ERRF, *REG, *REG_C, ep);
      if (HDIM[0] > 0) h = nn.hess (x, y, fw, *ERRF, *REG, *REG_C);
    }
    else
    {
      (*errv) = nn.train (x, y, *ERRF, *REG, *REG_C, ep);
      if (HDIM[0] > 0) h = nn.hess (x, y, *ERRF, *REG, *REG_C);
    }
    w = nn.get_weights();
    vec2Rvec (w, W);
    y = nn.predict (x);
    mat2Rmat (y, Y);
    mat2Rmat (h, H);
  }

  void R_ffnet_hess (double* X, long* XDIM, double* Y, long* YDIM, long* NHID, 
		     int* HID_T, int* OUT_T, int* SHORT_C, int* ERRF, int* REG, 
		     double* REG_C, double* W, long* NW, int* FW, long* NFW, 
		     double* H)
  {
    long i;
    vec w(W,*NW);
    intset fw(*NW);
    mat x(X,XDIM[0],XDIM[1]), y(Y,YDIM[0],YDIM[1]), h;
    ffnet nn (x.columns(), *NHID, y.columns(), *HID_T, *OUT_T, *SHORT_C);
    
    nn.set_weights (w);
    if (*NFW > 0)
    {
      for (i=0; i<*NFW; i++)
	fw.insert (FW[i]);
      h = nn.hess (x, y, fw, *ERRF, *REG, *REG_C);
    }
    else
      h = nn.hess (x, y, *ERRF, *REG, *REG_C);
    mat2Rmat (h, H);
  }
  
  void R_embed_vec (double* x, double* y, int* dim, int* n)
  {
    int i, j, nr, nc;
    
    nr = *n-*dim+1;
    nc = *dim;
    for (i=0; i<nc; i++)
      for (j=0; j<nr; j++)  
	y[j+nr*(nc-i-1)] = x[i+j];
  }
  
}






