\name{prune}
\title{Prune the Least Significant Weight}
\usage{
prune (nn)
}
\alias{prune}
\arguments{
  \item{nn}{An object returned by \code{\link{ffnet}}.}
}
\description{
  This procedure prunes the least significant weight from the weight
  vector of \code{nn}.
}
\details{
  Fixed weights of \code{nn} are not analyzed and treated as pruned in
  an earlier step. 
  
  Significance is measured in terms of the p-values computed via
  \code{\link{summary.ffnet}}. This will only work if the computed
  Hessian is positive-definite.
}
\value{
  A list containing the following components:
  \item{wts}{the pruned weight vector, i.e., the pruned weight is set to
    zero.}
  \item{fwts}{a vector of integers containing the indices of the pruned
    weights.}
}
\author{A. Trapletti}
\seealso{
  \code{\link{print.summary.ffnet}}, \code{\link{hessian.ffnet}}
}
\examples{
data (lynx)
x <- log10(lynx)

summary (nn <- ffnet (x, lag=12))
summary (nn <- ffnet (x, lag=12, wts=prune(nn)$wts,fwts=prune(nn)$fwts))
}
\keyword{neural, ts}


