/*
 * Decompiled with CFR 0.152.
 */
package dmLab.mcfs;

import dmLab.array.Array;
import dmLab.array.FArray;
import dmLab.classifier.Classifier;
import dmLab.classifier.Params;
import dmLab.experiment.ExperimentParams;
import dmLab.mcfs.mcfsEngine.MCFSAutoParams;
import dmLab.utils.StringUtils;
import java.util.Properties;
import java.util.Random;

public final class MCFSParams
extends ExperimentParams {
    public static String FILESUFIX_RI = "RI.csv";
    public static String FILESUFIX_RI_PHASE_1 = "RI_phase_1.csv";
    public static String FILESUFIX_RI_PHASE_2 = "RI_phase_2.csv";
    public static String FILESUFIX_ID = "ID.csv";
    public static String FILESUFIX_TOPRANKING = "topRanking.csv";
    public static String FILESUFIX_DISTANCE = "distances.csv";
    public static String FILESUFIX_MATRIX = "cmatrix.csv";
    public static String FILESUFIX_MATRIX_TOP = "cmatrix_top.csv";
    public static String FILESUFIX_CUTOFF = "cutoff.csv";
    public static String FILESUFIX_CV_RESULT = "cv_accuracy.csv";
    public static String FILESUFIX_PERMUTATIONS = "permutations.csv";
    public static String FILESUFIX_RULESET = "jrip.txt";
    public static String FILESUFIX_PREDICTION_STATS = "predictionStats.csv";
    public static String FILESUFIX_DATA = "data";
    public static String CONTRAST_ATTR_NAME = "mcfs_contrast_attr_";
    public static String FIX_ATTR_PREFIX = "x_";
    private static String[] CUTOFF_METHODS = new String[]{"mean", "criticalAngle", "kmeans", "contrast", "permutations"};
    private static int PROJECTION_SIZE_MIN = 1;
    public static int CONTRAST_ATTR_MIN = 1;
    public String filesufix_RI = FILESUFIX_RI;
    public int seed;
    public int progressTopMinSize;
    public boolean progressShow;
    public int progressInterval;
    public int threadsNumber;
    public int model;
    private String target;
    public int mode;
    public boolean buildID;
    public boolean finalRuleset;
    public boolean finalCV;
    public int finalCVSetSize;
    public int finalCVRepetitions;
    public int finalCVfolds;
    public String cutoffMethod;
    public int cutoffPermutations;
    private int featureFreq;
    public float balance;
    public int projections;
    public float projectionSize;
    private int projectionSizeMax;
    public int splits;
    public float splitRatio;
    public int splitSetSize;
    public float u;
    public float v;
    public float cutoffAlpha;
    public float cutoffAngle;
    public float contrastSize;
    public float contrastCutoff;
    public boolean zipResult;
    public boolean saveResultFiles;
    public boolean savePrunedData;
    public float minTopRankingSize;
    public int wekaClassifierMode;
    public boolean useGainRatio;
    public int maxConnectionDepth;
    public int qMethod;
    public boolean useComplexQuality;
    public boolean useDiversityMeasure;
    public int[] balancedClassSizes;
    public int[] splitSetClassSizes;
    public int projectionsValue;
    public int projectionSizeValue;
    public int phase;

    public MCFSParams() {
        ((Params)this).setDefault();
    }

    @Override
    public final boolean setDefault() {
        super.setDefault();
        this.filesufix_RI = FILESUFIX_RI;
        this.label = "MCFS";
        this.inputFilesPATH = DEFAULT_DATA_PATH;
        this.resFilesPATH = DEFAULT_RES_PATH;
        this.verbose = false;
        this.inputFileName = "";
        this.testFileName = null;
        this.outputFileName = null;
        this.seed = new Random(System.currentTimeMillis()).nextInt();
        this.progressTopMinSize = 30;
        this.progressInterval = 10;
        this.progressShow = true;
        this.threadsNumber = 4;
        this.model = Classifier.AUTO;
        this.target = "";
        this.mode = 1;
        this.buildID = true;
        this.finalRuleset = true;
        this.finalCV = true;
        this.finalCVSetSize = 1000;
        this.finalCVRepetitions = 3;
        this.finalCVfolds = 10;
        this.cutoffMethod = "mean";
        this.cutoffPermutations = 20;
        this.featureFreq = 150;
        this.balance = MCFSAutoParams.AUTO;
        this.projections = MCFSAutoParams.AUTO;
        this.projectionsValue = -1;
        this.projectionSize = MCFSAutoParams.AUTO;
        this.projectionSizeValue = -1;
        this.projectionSizeMax = 1000;
        this.splits = 5;
        this.splitRatio = 0.66f;
        this.splitSetSize = 1000;
        this.u = 1.0f;
        this.v = 1.0f;
        this.cutoffAlpha = 0.05f;
        this.cutoffAngle = 0.01f;
        this.contrastSize = 0.1f;
        this.contrastCutoff = 0.05f;
        this.minTopRankingSize = 0.0f;
        this.zipResult = true;
        this.saveResultFiles = true;
        this.savePrunedData = true;
        this.maxConnectionDepth = 5;
        this.useGainRatio = true;
        this.qMethod = 2;
        this.useComplexQuality = true;
        this.useDiversityMeasure = true;
        this.wekaClassifierMode = 0;
        this.balancedClassSizes = null;
        this.splitSetClassSizes = null;
        this.phase = 2;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String toString() {
        void var1_1;
        StringBuffer tmp = new StringBuffer();
        tmp.append(super.toString()).append('\n');
        tmp.append("### MCFS Parameters ### \n");
        tmp.append("mcfs.seed = " + this.seed).append('\n');
        tmp.append("mcfs.showDistanceProgress = " + this.progressShow).append('\n');
        tmp.append("mcfs.progressInterval = " + this.progressInterval).append('\n');
        tmp.append("mcfs.threadsNumber = " + this.threadsNumber).append('\n');
        tmp.append("mcfs.model = " + Classifier.int2label(this.model)).append('\n');
        tmp.append("mcfs.mode = " + this.mode).append('\n');
        tmp.append("target = " + this.target).append('\n');
        tmp.append('\n');
        tmp.append("mcfs.buildID = " + this.buildID).append('\n');
        tmp.append("mcfs.finalRuleset = " + this.finalRuleset).append('\n');
        tmp.append("mcfs.finalCV = " + this.finalCV).append('\n');
        tmp.append("mcfs.finalCVSetSize = " + this.finalCVSetSize).append('\n');
        tmp.append("mcfs.finalCVRepetitions = " + this.finalCVRepetitions).append('\n');
        tmp.append("mcfs.finalCVFolds = " + this.finalCVfolds).append('\n');
        tmp.append('\n');
        tmp.append("mcfs.cutoffMethod = " + this.cutoffMethod).append('\n');
        tmp.append("mcfs.cutoffPermutations = " + this.cutoffPermutations).append('\n');
        tmp.append("mcfs.featureFreq = " + this.featureFreq).append('\n');
        tmp.append("mcfs.balance = " + MCFSAutoParams.valueToString(this.balance)).append('\n');
        tmp.append('\n');
        tmp.append("mcfs.projections = " + MCFSAutoParams.valueToString(this.projections)).append('\n');
        tmp.append("mcfs.projectionSize = " + MCFSAutoParams.valueToString(this.projectionSize)).append('\n');
        tmp.append("mcfs.projectionSizeMax = " + this.projectionSizeMax).append('\n');
        tmp.append("mcfs.splits = " + this.splits).append('\n');
        tmp.append("mcfs.splitRatio = " + this.splitRatio).append('\n');
        tmp.append("mcfs.splitSetSize = " + this.splitSetSize).append('\n');
        tmp.append('\n');
        tmp.append("mcfs.u = " + this.u).append('\n');
        tmp.append("mcfs.v = " + this.v).append('\n');
        tmp.append("mcfs.cutoffAlpha = " + this.cutoffAlpha).append('\n');
        tmp.append("mcfs.cutoffAngle = " + this.cutoffAngle).append('\n');
        tmp.append("mcfs.contrastSize = " + this.contrastSize).append('\n');
        tmp.append("mcfs.contrastCutoff = " + this.contrastCutoff).append('\n');
        tmp.append('\n');
        tmp.append("mcfs.zipResult = " + this.zipResult).append('\n');
        tmp.append("mcfs.saveResultFiles = " + this.saveResultFiles).append('\n');
        tmp.append("mcfs.savePrunedData = " + this.savePrunedData).append('\n');
        tmp.append('\n');
        tmp.append("j48.useGainRatio = " + this.useGainRatio).append('\n');
        tmp.append("j48.maxConnectionDepth = " + this.maxConnectionDepth).append('\n');
        tmp.append("adx.useComplexQuality = " + this.useComplexQuality).append('\n');
        tmp.append("adx.qMethod = " + this.qMethod).append('\n');
        tmp.append("sliq.useDiversityMeasure = " + this.useDiversityMeasure).append('\n');
        tmp.append('\n');
        tmp.append("#mcfs.projectionsValue = " + this.projectionsValue).append('\n');
        tmp.append("#mcfs.projectionSizeValue = " + this.projectionSizeValue).append('\n');
        tmp.append('\n');
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final boolean update(Properties properties) {
        void var1_1;
        void var2_2;
        if (!super.update(properties)) {
            return false;
        }
        this.testFileName = null;
        this.outputFileName = null;
        String seedProp = properties.getProperty("mcfs.seed", "");
        this.seed = seedProp.trim().length() == 0 ? new Random(System.currentTimeMillis()).nextInt() : Integer.valueOf((String)var2_2).intValue();
        this.progressShow = Boolean.valueOf(properties.getProperty("mcfs.progressShow", "true"));
        this.progressInterval = Integer.valueOf(properties.getProperty("mcfs.progressInterval", "10"));
        this.threadsNumber = Integer.valueOf(properties.getProperty("mcfs.threadsNumber", "4"));
        this.model = Classifier.label2int(properties.getProperty("mcfs.model", "auto"));
        this.mode = Integer.valueOf(properties.getProperty("mcfs.mode", "1"));
        this.target = properties.getProperty("target", "");
        this.buildID = Boolean.valueOf(properties.getProperty("mcfs.buildID", "true"));
        this.finalRuleset = Boolean.valueOf(properties.getProperty("mcfs.finalRuleset", "true"));
        this.finalCV = Boolean.valueOf(properties.getProperty("mcfs.finalCV", "true"));
        this.finalCVSetSize = Integer.valueOf(properties.getProperty("mcfs.finalCVSetSize", "1000"));
        this.finalCVRepetitions = Integer.valueOf(properties.getProperty("mcfs.finalCVRepetitions", "3"));
        this.finalCVfolds = Integer.valueOf(properties.getProperty("mcfs.finalCVfolds", "10"));
        this.cutoffMethod = properties.getProperty("mcfs.cutoffMethod", "mean");
        this.cutoffPermutations = Integer.valueOf(properties.getProperty("mcfs.cutoffPermutations", "20"));
        this.featureFreq = Integer.valueOf(properties.getProperty("mcfs.featureFreq", "150"));
        this.balance = MCFSAutoParams.valueToFloat("mcfs.balance", properties.getProperty("mcfs.balance", "auto"));
        this.projections = (int)MCFSAutoParams.valueToFloat("mcfs.projections", properties.getProperty("mcfs.projections", "auto"));
        this.projectionSize = MCFSAutoParams.valueToFloat("mcfs.projectionSize", properties.getProperty("mcfs.projectionSize", "auto"));
        this.projectionSizeMax = Integer.valueOf(properties.getProperty("mcfs.projectionSizeMax", "500"));
        this.splits = Integer.valueOf(properties.getProperty("mcfs.splits", "5"));
        this.splitRatio = Float.valueOf(properties.getProperty("mcfs.splitRatio", "0.66")).floatValue();
        this.splitSetSize = Float.valueOf(properties.getProperty("mcfs.splitSetSize", "1000")).intValue();
        this.u = Float.valueOf(properties.getProperty("mcfs.u", "1")).floatValue();
        this.v = Float.valueOf(properties.getProperty("mcfs.v", "1")).floatValue();
        this.cutoffAngle = Float.valueOf(properties.getProperty("mcfs.cutoffAngle", "0.01")).floatValue();
        this.cutoffAlpha = Float.valueOf(properties.getProperty("mcfs.cutoffAlpha", "0.05")).floatValue();
        this.contrastSize = Float.valueOf(properties.getProperty("mcfs.contrastSize", "0.1")).floatValue();
        this.contrastCutoff = Float.valueOf(properties.getProperty("mcfs.contrastCutoff", "0.05")).floatValue();
        this.zipResult = Boolean.valueOf(properties.getProperty("mcfs.zipResult", "true"));
        this.savePrunedData = Boolean.valueOf(properties.getProperty("mcfs.savePrunedData", "true"));
        this.useGainRatio = Boolean.valueOf(properties.getProperty("j48.useGainRatio", "true"));
        this.maxConnectionDepth = Integer.valueOf(properties.getProperty("j48.maxConnectionDepth", "3"));
        this.qMethod = Integer.valueOf(properties.getProperty("adx.qMethod", "2"));
        this.useComplexQuality = Boolean.valueOf(properties.getProperty("adx.useComplexQuality", "true"));
        this.useDiversityMeasure = Boolean.valueOf(var1_1.getProperty("sliq.useDiversityMeasure", "true"));
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean check(FArray array) {
        if (!super.check(array)) {
            return false;
        }
        if (this.splits <= 0) {
            System.err.println("Warning! Incorrect value of splits: " + this.splits + " Using default value = 5.");
            this.splits = 5;
        }
        if (this.splitRatio <= 0.0f || this.splitRatio >= 1.0f) {
            System.err.println("Warning! Incorrect value of splitRatio: " + this.splitRatio + " Using default value = 0.66.");
            this.splitRatio = 0.66f;
        }
        if (this.cutoffPermutations != 0 && this.cutoffPermutations < 3) {
            System.err.println("Warning! Incorrect value of cutoffPermutations: " + this.cutoffPermutations + " Using minimum value = 3.\n");
            this.cutoffPermutations = 3;
        }
        if (this.cutoffPermutations == 0 && this.cutoffMethod.equalsIgnoreCase("permutations")) {
            System.err.println("Warning! Value of cutoffPermutations = " + this.cutoffPermutations + " and cutoffMethod = '" + this.cutoffMethod + "'. Using cutoffMethod = 'mean'.\n");
            this.cutoffMethod = "mean";
        }
        if (this.cutoffAlpha <= 0.0f) {
            System.err.println("Warning! Incorrect value of cutPointAlpha: " + this.cutoffAlpha + " Using default value = 0.05.\n");
            this.cutoffAlpha = 0.05f;
        }
        if (this.model != Classifier.M5 && this.model != Classifier.J48 && this.model != Classifier.ADX && this.model != Classifier.SLIQ && this.model != Classifier.AUTO) {
            System.err.println("Error! Incorrect classifier: " + this.model);
            return false;
        }
        if (!StringUtils.equalsToAny(this.cutoffMethod, CUTOFF_METHODS)) {
            System.err.println("Error! Incorrect cutoffMethod: '" + this.cutoffMethod + "'");
            return false;
        }
        if (this.mode != 1 && this.mode != 2) {
            System.err.println("Warning! Incorrect value of mode: " + this.mode + " Using default value = 1.\n");
            this.mode = 1;
        }
        if (array != null) {
            if (this.verbose) {
                FArray fArray = array;
                System.out.println("MCFSParams.check() before: target = " + this.target + "; projectionSize = " + this.projectionSize + "; projections = " + this.projections + "; featureFreq = " + this.featureFreq + "; projectionSizeValue = " + this.projectionSizeValue + "; projectionsValue = " + this.projectionsValue + "; array.colsNumber() = " + fArray.attributes.length + "; array.rowsNumber() = " + ((Array)array).rowsNumber());
            }
            this.target = array.attributes[array.getDecAttrIdx()].name;
            this.projectionSizeValue = MCFSAutoParams.setProjectionSize(this.projectionSize, PROJECTION_SIZE_MIN, this.projectionSizeMax, array);
            this.projectionsValue = MCFSAutoParams.setProjections(this.projections, this.projectionSizeValue, this.featureFreq, array);
            if (this.model == Classifier.AUTO) {
                void var1_1;
                if (var1_1.isTargetNominal()) {
                    this.model = Classifier.J48;
                    System.out.println("Nominal target detected - using J48 model");
                } else {
                    this.model = Classifier.M5;
                    System.out.println("Numeric target detected - using M5 model");
                }
            }
            if (this.verbose) {
                System.out.println("MCFSParams.check() after: target = " + this.target + "; projectionSizeValue = " + this.projectionSizeValue + "; projectionsValue = " + this.projectionsValue + "; model = " + Classifier.int2label(this.model));
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final MCFSParams clone() {
        void var1_1;
        MCFSParams p = new MCFSParams();
        MCFSParams mCFSParams = this;
        MCFSParams mCFSParams2 = p;
        super.set(mCFSParams);
        mCFSParams2.filesufix_RI = mCFSParams.filesufix_RI;
        mCFSParams2.seed = mCFSParams.seed;
        mCFSParams2.progressShow = mCFSParams.progressShow;
        mCFSParams2.progressInterval = mCFSParams.progressInterval;
        mCFSParams2.progressTopMinSize = mCFSParams.progressTopMinSize;
        mCFSParams2.threadsNumber = mCFSParams.threadsNumber;
        mCFSParams2.model = mCFSParams.model;
        mCFSParams2.target = mCFSParams.target;
        mCFSParams2.buildID = mCFSParams.buildID;
        mCFSParams2.finalRuleset = mCFSParams.finalRuleset;
        mCFSParams2.finalCV = mCFSParams.finalCV;
        mCFSParams2.finalCVSetSize = mCFSParams.finalCVSetSize;
        mCFSParams2.finalCVRepetitions = mCFSParams.finalCVRepetitions;
        mCFSParams2.finalCVfolds = mCFSParams.finalCVfolds;
        mCFSParams2.cutoffMethod = mCFSParams.cutoffMethod;
        mCFSParams2.cutoffPermutations = mCFSParams.cutoffPermutations;
        mCFSParams2.featureFreq = mCFSParams.featureFreq;
        mCFSParams2.balance = mCFSParams.balance;
        mCFSParams2.projections = mCFSParams.projections;
        mCFSParams2.projectionsValue = mCFSParams.projectionsValue;
        mCFSParams2.projectionSize = mCFSParams.projectionSize;
        mCFSParams2.projectionSizeMax = mCFSParams.projectionSizeMax;
        mCFSParams2.projectionSizeValue = mCFSParams.projectionSizeValue;
        mCFSParams2.splits = mCFSParams.splits;
        mCFSParams2.splitRatio = mCFSParams.splitRatio;
        mCFSParams2.splitSetSize = mCFSParams.splitSetSize;
        mCFSParams2.u = mCFSParams.u;
        mCFSParams2.v = mCFSParams.v;
        mCFSParams2.cutoffAlpha = mCFSParams.cutoffAlpha;
        mCFSParams2.cutoffAngle = mCFSParams.cutoffAngle;
        mCFSParams2.contrastSize = mCFSParams.contrastSize;
        mCFSParams2.contrastCutoff = mCFSParams.contrastCutoff;
        mCFSParams2.saveResultFiles = mCFSParams.saveResultFiles;
        mCFSParams2.zipResult = mCFSParams.zipResult;
        mCFSParams2.savePrunedData = mCFSParams.savePrunedData;
        mCFSParams2.wekaClassifierMode = mCFSParams.wekaClassifierMode;
        mCFSParams2.useGainRatio = mCFSParams.useGainRatio;
        mCFSParams2.maxConnectionDepth = mCFSParams.maxConnectionDepth;
        mCFSParams2.qMethod = mCFSParams.qMethod;
        mCFSParams2.useComplexQuality = mCFSParams.useComplexQuality;
        mCFSParams2.useDiversityMeasure = mCFSParams.useDiversityMeasure;
        return var1_1;
    }

    public static String[] getAllResultFileName(String experimentName) {
        String[] stringArray;
        stringArray = new String[]{experimentName + "__" + FILESUFIX_RI, experimentName + "__" + FILESUFIX_RI_PHASE_1, experimentName + "__" + FILESUFIX_RI_PHASE_2, experimentName + "_" + FILESUFIX_ID, experimentName + "_" + FILESUFIX_TOPRANKING, experimentName + "_" + FILESUFIX_DISTANCE, experimentName + "_" + FILESUFIX_MATRIX, experimentName + "_" + FILESUFIX_MATRIX_TOP, experimentName + "_" + FILESUFIX_CUTOFF, experimentName + "_" + FILESUFIX_CV_RESULT, experimentName + "_" + FILESUFIX_PERMUTATIONS, experimentName + "_" + FILESUFIX_RULESET, experimentName + "_" + FILESUFIX_PREDICTION_STATS, experimentName + "_" + FILESUFIX_DATA + ".csv", (String)stringArray + "_" + FILESUFIX_DATA + ".adh"};
        return stringArray;
    }
}

