/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.timeseries.regression;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import jdplus.toolkit.base.api.timeseries.TimeSeriesDomain;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.TsUnit;
import jdplus.toolkit.base.api.timeseries.regression.ISystemVariable;
import jdplus.toolkit.base.api.timeseries.regression.IUserVariable;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class Ramp
implements ISystemVariable,
IUserVariable {
    @NonNull
    private final LocalDateTime start;
    @NonNull
    private final LocalDateTime end;

    @Override
    public int dim() {
        return 1;
    }

    @Override
    public <D extends TimeSeriesDomain<?>> String description(D context) {
        int period = 0;
        if (context instanceof TsDomain) {
            TsDomain dom = (TsDomain)context;
            period = dom.getAnnualFrequency();
        }
        StringBuilder builder = new StringBuilder();
        if (period <= 0) {
            builder.append("ramp ").append(this.start.format(DateTimeFormatter.ISO_DATE)).append(" / ").append(this.end.format(DateTimeFormatter.ISO_DATE));
        } else {
            TsUnit unit = TsUnit.ofAnnualFrequency(period);
            TsPeriod pstart = TsPeriod.of(unit, this.start);
            TsPeriod pend = TsPeriod.of(unit, this.end);
            builder.append("ramp ").append(pstart.getStartAsShortString()).append(" / ").append(pend.getStartAsShortString());
        }
        return builder.toString();
    }

    @Generated
    public Ramp(@NonNull LocalDateTime start, @NonNull LocalDateTime end) {
        if (start == null) {
            throw new NullPointerException("start is marked non-null but is null");
        }
        if (end == null) {
            throw new NullPointerException("end is marked non-null but is null");
        }
        this.start = start;
        this.end = end;
    }

    @NonNull
    @Generated
    public LocalDateTime getStart() {
        return this.start;
    }

    @NonNull
    @Generated
    public LocalDateTime getEnd() {
        return this.end;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Ramp)) {
            return false;
        }
        Ramp other = (Ramp)o;
        LocalDateTime this$start = this.getStart();
        LocalDateTime other$start = other.getStart();
        if (this$start == null ? other$start != null : !((Object)this$start).equals(other$start)) {
            return false;
        }
        LocalDateTime this$end = this.getEnd();
        LocalDateTime other$end = other.getEnd();
        return !(this$end == null ? other$end != null : !((Object)this$end).equals(other$end));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LocalDateTime $start = this.getStart();
        result = result * 59 + ($start == null ? 43 : ((Object)$start).hashCode());
        LocalDateTime $end = this.getEnd();
        result = result * 59 + ($end == null ? 43 : ((Object)$end).hashCode());
        return result;
    }

    @Generated
    public @org.jspecify.annotations.NonNull String toString() {
        return "Ramp(start=" + String.valueOf(this.getStart()) + ", end=" + String.valueOf(this.getEnd()) + ")";
    }
}

