/*
 * Decompiled with CFR 0.152.
 */
package internal.toolkit.base.tsp;

import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.function.BiConsumer;
import jdplus.toolkit.base.tsp.fixme.Strings;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class UriBuilder {
    private final String scheme;
    private final String host;
    private String[] path;
    private SortedMap<String, String> query;
    private SortedMap<String, String> fragment;

    public UriBuilder(@NonNull String scheme, @NonNull String host) {
        if (scheme == null) {
            throw new NullPointerException("scheme is marked non-null but is null");
        }
        if (host == null) {
            throw new NullPointerException("host is marked non-null but is null");
        }
        if (scheme.isEmpty()) {
            throw new IllegalArgumentException("scheme can't be empty");
        }
        if (host.isEmpty()) {
            throw new IllegalArgumentException("host can't be empty");
        }
        this.scheme = scheme;
        this.host = host;
        this.reset();
    }

    @NonNull
    public UriBuilder reset() {
        this.path = null;
        this.query = null;
        this.fragment = null;
        return this;
    }

    @NonNull
    public UriBuilder path(String ... path) {
        this.path = path;
        return this;
    }

    @NonNull
    public UriBuilder query(@Nullable SortedMap<String, String> query) {
        this.query = query;
        return this;
    }

    @NonNull
    public UriBuilder fragment(@Nullable SortedMap<String, String> fragment) {
        this.fragment = fragment;
        return this;
    }

    @NonNull
    public String buildString() {
        StringBuilder result = new StringBuilder();
        result.append(this.scheme);
        result.append("://");
        result.append(this.host);
        if (this.path != null) {
            UriBuilder.appendPathElements(result.append('/'), this.path);
        }
        if (this.query != null) {
            UriBuilder.appendKeyValuePairs(result.append('?'), this.query);
        }
        if (this.fragment != null) {
            UriBuilder.appendKeyValuePairs(result.append('#'), this.fragment);
        }
        return result.toString();
    }

    public URI build() {
        return URI.create(this.buildString());
    }

    private static String encode(String o) {
        return URLEncoder.encode(o, StandardCharsets.UTF_8).replace("+", "%20");
    }

    private static String decode(String o) {
        return URLDecoder.decode(o, StandardCharsets.UTF_8);
    }

    private static void appendKeyValuePair(@NonNull StringBuilder sb, @NonNull Map.Entry<String, String> o) {
        if (sb == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        if (o == null) {
            throw new NullPointerException("o is marked non-null but is null");
        }
        sb.append(UriBuilder.encode(o.getKey()));
        sb.append('=');
        sb.append(UriBuilder.encode(o.getValue()));
    }

    private static void appendKeyValuePairs(@NonNull StringBuilder sb, @NonNull Map<String, String> keyValues) {
        if (sb == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        if (keyValues == null) {
            throw new NullPointerException("keyValues is marked non-null but is null");
        }
        if (!keyValues.isEmpty()) {
            Iterator<Map.Entry<String, String>> iterator = keyValues.entrySet().iterator();
            UriBuilder.appendKeyValuePair(sb, iterator.next());
            while (iterator.hasNext()) {
                UriBuilder.appendKeyValuePair(sb.append('&'), iterator.next());
            }
        }
    }

    private static void appendPathElements(@NonNull StringBuilder sb, @NonNull String[] array) {
        if (sb == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (array.length > 0) {
            int i = 0;
            sb.append(UriBuilder.encode(array[i]));
            while (++i < array.length) {
                sb.append('/').append(UriBuilder.encode(array[i]));
            }
        }
    }

    public static @Nullable String[] getPathArray(@NonNull URI uri, int expectedSize) {
        if (uri == null) {
            throw new NullPointerException("uri is marked non-null but is null");
        }
        String path = uri.getRawPath();
        return path != null && !path.isEmpty() ? UriBuilder.splitToArray(path.subSequence(1, path.length()), expectedSize) : null;
    }

    public static @Nullable Map<String, String> getQueryMap(@NonNull URI uri) {
        if (uri == null) {
            throw new NullPointerException("uri is marked non-null but is null");
        }
        String query = uri.getRawQuery();
        return query != null ? UriBuilder.splitMap(query) : null;
    }

    public static @Nullable Map<String, String> getFragmentMap(@NonNull URI uri) {
        if (uri == null) {
            throw new NullPointerException("uri is marked non-null but is null");
        }
        String fragment = uri.getRawFragment();
        return fragment != null ? UriBuilder.splitMap(fragment) : null;
    }

    private static @Nullable String[] splitToArray(@NonNull CharSequence input, int expectedSize) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        Iterator<String> items = Strings.splitToIterator('/', input);
        if (expectedSize == 0 || !items.hasNext()) {
            return null;
        }
        String[] result = new String[expectedSize];
        int index = 0;
        do {
            result[index++] = UriBuilder.decode(items.next());
        } while (index < expectedSize && items.hasNext());
        return !items.hasNext() && index == expectedSize ? result : null;
    }

    private static @Nullable Map<String, String> splitMap(@NonNull CharSequence input) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (input.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        return UriBuilder.splitMapTo(input, result::put) ? result : null;
    }

    private static boolean splitMapTo(@NonNull CharSequence input, @NonNull BiConsumer<String, String> consumer) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        Iterator<String> iterable = Strings.splitToIterator('&', input);
        while (iterable.hasNext()) {
            String entry = iterable.next();
            Iterator<String> entryFields = Strings.splitToIterator('=', (CharSequence)entry);
            if (!entryFields.hasNext()) {
                return false;
            }
            String key = entryFields.next();
            if (!entryFields.hasNext()) {
                return false;
            }
            String value = entryFields.next();
            if (entryFields.hasNext()) {
                return false;
            }
            consumer.accept(UriBuilder.decode(key), UriBuilder.decode(value));
        }
        return true;
    }
}

