/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.min_max;

import org.chocosolver.sat.Reason;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Explained;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.tools.ArrayUtils;

@Explained
public class PropMax
extends Propagator<IntVar> {
    private final int n;

    public PropMax(IntVar[] variables, IntVar maxVar) {
        super((Variable[])ArrayUtils.concat(variables, maxVar), (Priority)PropagatorPriority.LINEAR, false);
        this.n = variables.length;
        assert (this.n > 0);
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return IntEventType.boundAndInst();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        boolean filter;
        do {
            filter = false;
            int lb = Integer.MIN_VALUE;
            int ub = Integer.MIN_VALUE;
            int max = ((IntVar[])this.vars)[this.n].getUB();
            for (int i = 0; i < this.n; ++i) {
                filter |= ((IntVar[])this.vars)[i].updateUpperBound(max, this, this.lcg() ? Reason.r(((IntVar[])this.vars)[this.n].getMaxLit()) : Reason.undef());
                lb = Math.max(lb, ((IntVar[])this.vars)[i].getLB());
                ub = Math.max(ub, ((IntVar[])this.vars)[i].getUB());
            }
            filter |= ((IntVar[])this.vars)[this.n].updateLowerBound(lb, this, this.lcg() ? Propagator.lbounds(((IntVar[])this.vars)[this.n], this.vars) : Reason.undef());
            filter |= ((IntVar[])this.vars)[this.n].updateUpperBound(ub, this, this.lcg() ? Propagator.ubounds(((IntVar[])this.vars)[this.n], this.vars) : Reason.undef());
            lb = Math.max(lb, ((IntVar[])this.vars)[this.n].getLB());
            int c = 0;
            int idx = -1;
            for (int i = 0; i < this.n && c >= i - 1; ++i) {
                if (((IntVar[])this.vars)[i].getUB() < lb) {
                    ++c;
                    continue;
                }
                idx = i;
            }
            if (c != ((IntVar[])this.vars).length - 2) continue;
            Reason r = Reason.undef();
            if (this.lcg()) {
                int[] ps = new int[this.n + 1];
                int i = 0;
                int m = 1;
                while (i < this.n) {
                    ps[m] = ((IntVar[])this.vars)[i].getMaxLit();
                    ++i;
                    ++m;
                }
                ps[idx + 1] = ((IntVar[])this.vars)[this.n].getMinLit();
                r = Reason.r(ps);
            }
            filter = ((IntVar[])this.vars)[idx].updateLowerBound(((IntVar[])this.vars)[this.n].getLB(), this, r);
            if (!((IntVar[])this.vars)[this.n].isInstantiated() || !((IntVar[])this.vars)[idx].isInstantiatedTo(((IntVar[])this.vars)[this.n].getValue())) continue;
            this.setPassive();
            return;
        } while (filter);
    }

    @Override
    public ESat isEntailed() {
        int i;
        int ub = ((IntVar[])this.vars)[this.n].getUB();
        int maxUb = ((IntVar[])this.vars)[0].getUB();
        for (i = 0; i < this.n; ++i) {
            maxUb = Math.max(maxUb, ((IntVar[])this.vars)[i].getUB());
            if (((IntVar[])this.vars)[i].getLB() <= ub) continue;
            return ESat.FALSE;
        }
        if (maxUb < ((IntVar[])this.vars)[this.n].getLB()) {
            return ESat.FALSE;
        }
        for (i = 0; i < this.n; ++i) {
            if (((IntVar[])this.vars)[i].getUB() <= ub) continue;
            return ESat.UNDEFINED;
        }
        if (((IntVar[])this.vars)[this.n].isInstantiated()) {
            for (i = 0; i < this.n; ++i) {
                if (!((IntVar[])this.vars)[i].isInstantiatedTo(ub)) continue;
                return ESat.TRUE;
            }
        }
        return ESat.UNDEFINED;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(((IntVar[])this.vars)[this.n]).append(" = max(");
        sb.append(((IntVar[])this.vars)[0]);
        for (int i = 1; i < this.n; ++i) {
            sb.append(", ");
            sb.append(((IntVar[])this.vars)[i]);
        }
        sb.append(")");
        return sb.toString();
    }
}

