/*
 * Decompiled with CFR 0.152.
 */
package org._3pq.jgrapht.traverse;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org._3pq.jgrapht.DirectedGraph;
import org._3pq.jgrapht.Edge;
import org._3pq.jgrapht.traverse.CrossComponentIterator;
import org._3pq.jgrapht.util.ModifiableInteger;

public class TopologicalOrderIterator
extends CrossComponentIterator {
    private LinkedList m_queue;
    private Map m_inDegreeMap;

    public TopologicalOrderIterator(DirectedGraph directedGraph) {
        this(directedGraph, new LinkedList(), new HashMap());
    }

    private TopologicalOrderIterator(DirectedGraph directedGraph, LinkedList linkedList, Map map) {
        this(directedGraph, TopologicalOrderIterator.initialize(directedGraph, linkedList, map));
        this.m_queue = linkedList;
        this.m_inDegreeMap = map;
    }

    private TopologicalOrderIterator(DirectedGraph directedGraph, Object object) {
        super(directedGraph, object);
    }

    protected boolean isConnectedComponentExhausted() {
        return this.m_queue.isEmpty();
    }

    protected void encounterVertex(Object object, Edge edge) {
        this.putSeenData(object, null);
        this.decrementInDegree(object);
    }

    protected void encounterVertexAgain(Object object, Edge edge) {
        this.decrementInDegree(object);
    }

    protected Object provideNextVertex() {
        return this.m_queue.removeFirst();
    }

    private void decrementInDegree(Object object) {
        ModifiableInteger modifiableInteger = (ModifiableInteger)this.m_inDegreeMap.get(object);
        if (modifiableInteger.value > 0) {
            --modifiableInteger.value;
            if (modifiableInteger.value == 0) {
                this.m_queue.addLast(object);
            }
        }
    }

    private static Object initialize(DirectedGraph directedGraph, LinkedList linkedList, Map map) {
        Iterator iterator = directedGraph.vertexSet().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            int n = directedGraph.inDegreeOf(e);
            map.put(e, new ModifiableInteger(n));
            if (n != 0) continue;
            linkedList.add(e);
        }
        if (linkedList.isEmpty()) {
            return null;
        }
        return linkedList.getFirst();
    }
}

