/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.formula;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.openscience.cdk.formula.ChemicalElement;
import org.openscience.cdk.formula.MolecularFormulaRange;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IIsotope;
import org.openscience.cdk.interfaces.IMolecularFormula;

class RangeMassDecomposer {
    private final List<ChemicalElement> weights;
    private final IIsotope[] elements;
    private double precision = this.findOptimalPrecision();
    private double minError;
    private double maxError;
    private int[][][] ERTs = null;

    RangeMassDecomposer(IIsotope[] allowedIsotopes) {
        int n = allowedIsotopes.length;
        this.weights = new ArrayList<ChemicalElement>(n);
        this.elements = new IIsotope[allowedIsotopes.length];
        for (IIsotope allowedIsotope : allowedIsotopes) {
            this.weights.add(new ChemicalElement(allowedIsotope, allowedIsotope.getExactMass()));
        }
        Collections.sort(this.weights);
        for (int i = 0; i < n; ++i) {
            this.elements[i] = this.weights.get(i).getOwner();
        }
    }

    private static int gcd(int u, int v) {
        while (v != 0) {
            int r = u % v;
            u = v;
            v = r;
        }
        return u;
    }

    boolean isCompatible(IIsotope[] elements) {
        return Arrays.equals(elements, this.elements);
    }

    private double findOptimalPrecision() {
        return 1.6769132530931248E-4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        if (this.ERTs != null) {
            return;
        }
        RangeMassDecomposer rangeMassDecomposer = this;
        synchronized (rangeMassDecomposer) {
            if (this.ERTs != null) {
                return;
            }
            this.discretizeMasses();
            this.divideByGCD();
            this.computeLCMs();
            this.calcERT();
            this.computeErrors();
        }
    }

    boolean maybeDecomposable(double from, double to) {
        this.init();
        int[][][] ERTs = this.ERTs;
        int[] minmax = new int[2];
        this.integerBound(from, to, minmax);
        int a = this.weights.get(0).getIntegerMass();
        for (int i = minmax[0]; i <= minmax[1]; ++i) {
            int r = i % a;
            if (i < ERTs[0][r][this.weights.size() - 1]) continue;
            return true;
        }
        return false;
    }

    DecompIterator decomposeIterator(double from, double to, MolecularFormulaRange boundaries) {
        this.init();
        if (to < 0.0 || from < 0.0) {
            throw new IllegalArgumentException("Expect positive mass for decomposition: [" + from + ", " + to + "]");
        }
        if (to < from) {
            throw new IllegalArgumentException("Negative range given: [" + from + ", " + to + "]");
        }
        int[] minValues = new int[this.weights.size()];
        int[] boundsarray = new int[this.weights.size()];
        double cfrom = from;
        double cto = to;
        Arrays.fill(boundsarray, Integer.MAX_VALUE);
        if (boundaries != null) {
            for (int i = 0; i < boundsarray.length; ++i) {
                IIsotope el = this.weights.get(i).getOwner();
                int max = boundaries.getIsotopeCountMax(el);
                int min = boundaries.getIsotopeCountMin(el);
                if (min < 0 && max < 0) continue;
                boundsarray[i] = max - min;
                minValues[i] = min;
                if (minValues[i] <= 0) continue;
                double reduceWeightBy = this.weights.get(i).getMass() * (double)min;
                cfrom -= reduceWeightBy;
                cto -= reduceWeightBy;
            }
        }
        int[] minmax = new int[2];
        this.integerBound(cfrom, cto, minmax);
        int deviation = minmax[1] - minmax[0];
        if (1 << this.ERTs.length - 1 <= deviation) {
            this.calcERT(deviation);
        }
        int[][][] ERTs = this.ERTs;
        int[][] currentERT = deviation == 0 ? ERTs[0] : ERTs[32 - Integer.numberOfLeadingZeros(deviation)];
        return new DecompIterator(currentERT, minmax[0], minmax[1], from, to, minValues, boundsarray, this.weights);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calcERT(int deviation) {
        int[][][] ERTs = this.ERTs;
        int currentLength = ERTs.length;
        int[][] lastERT = ERTs[ERTs.length - 1];
        int[][] nextERT = new int[lastERT.length][this.weights.size()];
        if (currentLength == 1) {
            for (int j = 0; j < this.weights.size(); ++j) {
                nextERT[0][j] = Math.min(lastERT[nextERT.length - 1][j], lastERT[0][j]);
            }
            for (int i = 1; i < nextERT.length; ++i) {
                for (int j = 0; j < this.weights.size(); ++j) {
                    nextERT[i][j] = Math.min(lastERT[i][j], lastERT[i - 1][j]);
                }
            }
        } else {
            int j;
            int step;
            int i;
            for (i = step = 1 << currentLength - 2; i < nextERT.length; ++i) {
                for (j = 0; j < this.weights.size(); ++j) {
                    nextERT[i][j] = Math.min(lastERT[i][j], lastERT[i - step][j]);
                }
            }
            for (i = 0; i < step; ++i) {
                for (j = 0; j < this.weights.size(); ++j) {
                    nextERT[i][j] = Math.min(lastERT[i][j], lastERT[i + nextERT.length - step][j]);
                }
            }
        }
        RangeMassDecomposer rangeMassDecomposer = this;
        synchronized (rangeMassDecomposer) {
            int[][][] tables = this.ERTs;
            if (tables.length == currentLength) {
                this.ERTs = (int[][][])Arrays.copyOf(this.ERTs, this.ERTs.length + 1);
                this.ERTs[this.ERTs.length - 1] = nextERT;
            }
        }
        if (1 << currentLength - 1 <= deviation) {
            this.calcERT(deviation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calcERT() {
        int firstLongVal = this.weights.get(0).getIntegerMass();
        int[][] ERT = new int[firstLongVal][this.weights.size()];
        ERT[0][0] = 0;
        for (int i = 1; i < ERT.length; ++i) {
            ERT[i][0] = Integer.MAX_VALUE;
        }
        for (int j = 1; j < ERT[0].length; ++j) {
            ERT[0][j] = 0;
            int d = RangeMassDecomposer.gcd(firstLongVal, this.weights.get(j).getIntegerMass());
            for (int p = 0; p < d; ++p) {
                int i;
                int n;
                if (p == 0) {
                    n = 0;
                } else {
                    n = Integer.MAX_VALUE;
                    int argmin = p;
                    for (i = p; i < ERT.length; i += d) {
                        if (ERT[i][j - 1] >= n) continue;
                        n = ERT[i][j - 1];
                        argmin = i;
                    }
                    ERT[argmin][j] = n;
                }
                if (n == Integer.MAX_VALUE) {
                    for (i = p; i < ERT.length; i += d) {
                        ERT[i][j] = Integer.MAX_VALUE;
                    }
                    continue;
                }
                for (long i2 = 1L; i2 < (long)(ERT.length / d); ++i2) {
                    if ((n += this.weights.get(j).getIntegerMass()) < 0) {
                        throw new ArithmeticException("Integer overflow occurs. DECOMP cannot calculate decompositions for the given alphabet as it exceeds the 32 bit integer space. Please use a smaller precision value.");
                    }
                    int r = n % firstLongVal;
                    if (ERT[r][j - 1] < n) {
                        n = ERT[r][j - 1];
                    }
                    ERT[r][j] = n;
                }
            }
        }
        RangeMassDecomposer rangeMassDecomposer = this;
        synchronized (rangeMassDecomposer) {
            if (this.ERTs == null) {
                this.ERTs = new int[][][]{ERT};
            }
        }
    }

    private void discretizeMasses() {
        for (ChemicalElement weight : this.weights) {
            weight.setIntegerMass((int)(weight.getMass() / this.precision));
        }
    }

    private void divideByGCD() {
        if (this.weights.size() > 0) {
            int d = RangeMassDecomposer.gcd(this.weights.get(0).getIntegerMass(), this.weights.get(1).getIntegerMass());
            for (int i = 2; i < this.weights.size(); ++i) {
                if ((d = RangeMassDecomposer.gcd(d, this.weights.get(i).getIntegerMass())) != 1) continue;
                return;
            }
            this.precision *= (double)d;
            for (ChemicalElement weight : this.weights) {
                weight.setIntegerMass(weight.getIntegerMass() / d);
            }
        }
    }

    private void computeLCMs() {
        ChemicalElement first = this.weights.get(0);
        first.setL(1);
        first.setLcm(first.getIntegerMass());
        for (int i = 1; i < this.weights.size(); ++i) {
            ChemicalElement weight = this.weights.get(i);
            int temp = first.getIntegerMass() / RangeMassDecomposer.gcd(first.getIntegerMass(), weight.getIntegerMass());
            weight.setL(temp);
            weight.setLcm(temp * weight.getIntegerMass());
        }
    }

    private void computeErrors() {
        this.minError = 0.0;
        this.maxError = 0.0;
        for (ChemicalElement weight : this.weights) {
            double error = (this.precision * (double)weight.getIntegerMass() - weight.getMass()) / weight.getMass();
            this.minError = Math.min(this.minError, error);
            this.maxError = Math.max(this.maxError, error);
        }
    }

    private void integerBound(double from, double to, int[] bounds) {
        double fromD = Math.ceil((1.0 + this.minError) * from / this.precision);
        double toD = Math.floor((1.0 + this.maxError) * to / this.precision);
        if (fromD > 2.147483647E9 || toD > 2.147483647E9) {
            throw new ArithmeticException("Given mass is too large to decompose. Please use a smaller precision value, i.e. mass/precision have to be within 32 bit integer space");
        }
        bounds[0] = Math.max(0, (int)fromD);
        bounds[1] = Math.max(0, (int)toD);
    }

    static class DecompIterator {
        final int[][] ERT;
        final double minDoubleMass;
        final double maxDoubleMass;
        final int[] buffer;
        final int[] minValues;
        final int[] maxValues;
        final List<ChemicalElement> weights;
        final int[] j;
        final int[] m;
        final int[] lbound;
        final int[] r;
        final int k;
        final int a;
        final int deviation;
        final int ERTdev;
        boolean flagWhile;
        boolean rewind;
        int i;

        DecompIterator(int[][] ERT, int minIntegerMass, int maxIntegerMass, double minDoubleMass, double maxDoubleMass, int[] minValues, int[] maxValues, List<ChemicalElement> weights) {
            this.ERT = ERT;
            this.minDoubleMass = minDoubleMass;
            this.maxDoubleMass = maxDoubleMass;
            this.buffer = new int[weights.size()];
            if (minValues != null) {
                boolean allZero = true;
                for (int k : minValues) {
                    if (k <= 0) continue;
                    allZero = false;
                }
                this.minValues = (int[])(!allZero ? minValues : null);
            } else {
                this.minValues = null;
            }
            this.maxValues = maxValues;
            this.weights = weights;
            this.k = weights.size();
            this.j = new int[this.k];
            this.m = new int[this.k];
            this.lbound = new int[this.k];
            this.r = new int[this.k];
            this.flagWhile = false;
            this.a = weights.get(0).getIntegerMass();
            for (int i = 1; i < this.k; ++i) {
                this.lbound[i] = Integer.MAX_VALUE;
            }
            this.i = this.k - 1;
            this.m[this.i] = maxIntegerMass;
            this.rewind = false;
            this.deviation = maxIntegerMass - minIntegerMass;
            this.ERTdev = Integer.highestOneBit(this.deviation);
        }

        boolean next() {
            while (this.decomposeRangeIntegerMass()) {
                if (!this.checkCompomere()) continue;
                return true;
            }
            return false;
        }

        private boolean decomposeRangeIntegerMass() {
            if (this.rewind) {
                this.afterFindingADecomposition();
                this.rewind = false;
            }
            while (this.i != this.k) {
                if (this.i == 0) {
                    int v = this.m[this.i] / this.a;
                    if (v <= this.maxValues[0]) {
                        this.buffer[0] = v;
                        this.rewind = true;
                        return true;
                    }
                    ++this.i;
                    this.flagWhile = true;
                    int n = this.i - 1;
                    this.m[n] = this.m[n] - this.weights.get(this.i).getLcm();
                    int n2 = this.i;
                    this.buffer[n2] = this.buffer[n2] + this.weights.get(this.i).getL();
                    continue;
                }
                if (this.flagWhile) {
                    if (this.m[this.i - 1] >= this.lbound[this.i] && this.buffer[this.i] <= this.maxValues[this.i]) {
                        --this.i;
                        continue;
                    }
                    this.flagWhile = false;
                    continue;
                }
                if (this.j[this.i] < this.weights.get(this.i).getL() && this.m[this.i] - this.j[this.i] * this.weights.get(this.i).getIntegerMass() >= 0) {
                    this.buffer[this.i] = this.j[this.i];
                    this.m[this.i - 1] = this.m[this.i] - this.j[this.i] * this.weights.get(this.i).getIntegerMass();
                    this.r[this.i] = this.m[this.i - 1] % this.a;
                    int pos = this.r[this.i] - this.deviation + this.ERTdev;
                    if (pos < 0) {
                        pos += this.ERT.length;
                    }
                    this.lbound[this.i] = Math.min(this.ERT[this.r[this.i]][this.i - 1], this.ERT[pos][this.i - 1]);
                    this.flagWhile = true;
                    int n = this.i;
                    this.j[n] = this.j[n] + 1;
                    continue;
                }
                this.lbound[this.i] = Integer.MAX_VALUE;
                this.j[this.i] = 0;
                this.buffer[this.i] = 0;
                ++this.i;
                if (this.i == this.k) continue;
                this.flagWhile = true;
                int n = this.i - 1;
                this.m[n] = this.m[n] - this.weights.get(this.i).getLcm();
                int n3 = this.i;
                this.buffer[n3] = this.buffer[n3] + this.weights.get(this.i).getL();
            }
            return false;
        }

        private boolean checkCompomere() {
            if (this.minValues != null) {
                for (int j = 0; j < this.minValues.length; ++j) {
                    int n = j;
                    this.buffer[n] = this.buffer[n] + this.minValues[j];
                }
            }
            double exactMass = 0.0;
            for (int j = 0; j < this.buffer.length; ++j) {
                exactMass += (double)this.buffer[j] * this.weights.get(j).getMass();
            }
            return exactMass >= this.minDoubleMass && exactMass <= this.maxDoubleMass;
        }

        private void afterFindingADecomposition() {
            if (this.minValues != null) {
                for (int j = 0; j < this.minValues.length; ++j) {
                    int n = j;
                    this.buffer[n] = this.buffer[n] - this.minValues[j];
                }
            }
            ++this.i;
            this.flagWhile = true;
            int n = this.i - 1;
            this.m[n] = this.m[n] - this.weights.get(this.i).getLcm();
            int n2 = this.i;
            this.buffer[n2] = this.buffer[n2] + this.weights.get(this.i).getL();
        }

        IMolecularFormula generateCurrentMolecularFormula(IChemObjectBuilder builder) {
            IMolecularFormula formula = (IMolecularFormula)builder.newInstance(IMolecularFormula.class, new Object[0]);
            for (int k = 0; k < this.buffer.length; ++k) {
                if (this.buffer[k] <= 0) continue;
                formula.addIsotope(this.getCharacterAt(k), this.buffer[k]);
            }
            return formula;
        }

        int[] getCurrentCompomere() {
            return this.buffer;
        }

        IIsotope getCharacterAt(int index) {
            return this.weights.get(index).getOwner();
        }
    }
}

