/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.ui.swing;

import com.qarks.util.ui.swing.FileDropListener;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class FileDropHandler {
    private FileDropHandler() {
    }

    public static void addFileDropListener(Component component, final FileDropListener fileDropListener) {
        DropTargetAdapter dropTargetAdapter = new DropTargetAdapter(){

            @Override
            public void drop(DropTargetDropEvent dropTargetDropEvent) {
                try {
                    Transferable transferable = dropTargetDropEvent.getTransferable();
                    if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                        dropTargetDropEvent.acceptDrop(3);
                        Object object = transferable.getTransferData(DataFlavor.javaFileListFlavor);
                        if (object instanceof List) {
                            File[] fileArray;
                            List list = (List)object;
                            Iterator iterator = list.iterator();
                            Vector<File[]> vector = new Vector<File[]>();
                            while (iterator.hasNext()) {
                                fileArray = (File[])iterator.next();
                                vector.addElement(fileArray);
                            }
                            fileArray = new File[vector.size()];
                            vector.toArray(fileArray);
                            fileDropListener.onFileDropped(fileArray);
                        }
                        dropTargetDropEvent.getDropTargetContext().dropComplete(true);
                    } else {
                        dropTargetDropEvent.rejectDrop();
                    }
                }
                catch (Exception exception) {
                    dropTargetDropEvent.rejectDrop();
                }
            }
        };
        DropTarget dropTarget = new DropTarget(component, 1, dropTargetAdapter);
    }
}

