## ----include = FALSE----------------------------------------------------------
source("common.R")

path <- tempfile()
fs::dir_create(path)
path_git <- file.path(path, "git")
path_alice <- file.path(path, "alice")
path_bob <- file.path(path, "bob")
path_server <- file.path(path, "server")
path_sharepoint_alice <- file.path(path, "sharepoint")
path_sharepoint_bob <- path_sharepoint_alice

src <- system.file("examples/simple", package = "orderly", mustWork = TRUE)
fs::dir_copy(src, path_git)

gert::git_init(path_git)
gert::git_add(".", repo = path_git)
user <- "Alice <alice@example.com>"
sha <- gert::git_commit("initial", author = user, committer = user,
                        repo = path_git)
if (gert::git_branch(repo = path_git) == "master") {
  gert::git_branch_move("master", "main", repo = path_git)
}

gert::git_clone(path_git, path_alice)
gert::git_clone(path_git, path_bob)
gert::git_clone(path_git, path_server)
orderly::orderly_init(path_server, use_file_store = TRUE, path_archive = NULL)

knitr::opts_hooks$set(as = function(options) {
  options$class.source <- options$as
  options$class.output <- options$as
  options
})

## -----------------------------------------------------------------------------
library(orderly)

## ----as = "alice", echo = FALSE-----------------------------------------------
fs::dir_tree(path_alice, all = TRUE, glob = "*/.git", invert = TRUE)

## ----as = "alice", orderly_root = path_alice, error = TRUE--------------------
try({
orderly_metadata_extract()
})

## ----as = "alice"-------------------------------------------------------------
orderly_init(path_alice)

## ----orderly_root = path_alice------------------------------------------------
orderly_metadata_extract()

## ----include = FALSE, orderly_root = path_alice-------------------------------
orderly_location_add_path("server", path = path_server)

## ----eval = FALSE, as = "alice"-----------------------------------------------
# orderly_location_add_packit("server", "http://packit.example.com")

## ----as = "alice", orderly_root = path_alice----------------------------------
id <- orderly_run("data")

## ----as = "alice", orderly_root = path_alice----------------------------------
orderly_location_push(id, "server")

## ----as = "bob"---------------------------------------------------------------
orderly_init(path_bob)

## ----include = FALSE, orderly_root = path_bob---------------------------------
orderly_location_add_path("server", path = path_server)

## ----eval = FALSE, as = "bob"-------------------------------------------------
# orderly_location_add_packit("server", "http://packit.example.com")

## ----as = "bob", orderly_root = path_bob--------------------------------------
orderly_metadata_extract(
  name = "data",
  allow_remote = TRUE, fetch_metadata = TRUE)

## ----as = "bob", orderly_root = path_bob--------------------------------------
orderly_location_pull(id)

## ----as="alice"---------------------------------------------------------------
orderly_init(
  root = path_sharepoint_alice,
  path_archive = NULL,
  use_file_store = TRUE,
  require_complete_tree = TRUE
)

## ----as="alice", orderly_root = path_alice------------------------------------
orderly_location_add_path("sharepoint", path = path_sharepoint_alice)

## ----as="alice", orderly_root = path_alice------------------------------------
orderly_location_push(id, "sharepoint")

## ----as="bob", orderly_root = path_bob----------------------------------------
orderly_location_add_path("alices_orderly", path_sharepoint_bob)

## ----as="bob", orderly_root = path_bob----------------------------------------
orderly_location_fetch_metadata("alices_orderly")

