/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the LICENSE file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef H5Mprivate_H
#define H5Mprivate_H

#include "H5Mpublic.h"

#include "H5Oprivate.h" 
#include "H5Sprivate.h" 
#include "H5Zprivate.h" 

#ifdef NDEBUG
#undef H5M_DEBUG
#endif

#define H5M_ACS_KEY_PREFETCH_SIZE_NAME                                                                       \
    "key_prefetch_size" 
#define H5M_ACS_KEY_ALLOC_SIZE_NAME                                                                          \
    "key_alloc_size" 

#define H5D_TEMP_BUF_SIZE (1024 * 1024)

#define H5D_IO_VECTOR_SIZE 1024

#define H5D_VLEN_ALLOC      NULL
#define H5D_VLEN_ALLOC_INFO NULL
#define H5D_VLEN_FREE       NULL
#define H5D_VLEN_FREE_INFO  NULL

#define H5D_VIRTUAL_DEF_LIST_SIZE 8

H5_DLL herr_t H5M_init(void);

#endif 
