/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.x13;

import ec.tstoolkit.arima.estimation.IRegArimaProcessor;
import ec.tstoolkit.arima.estimation.RegArimaEstimation;
import ec.tstoolkit.arima.estimation.RegArimaModel;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.SymmetricMatrix;
import ec.tstoolkit.maths.realfunctions.IParametricMapping;
import ec.tstoolkit.maths.realfunctions.ISsqFunctionMinimizer;
import ec.tstoolkit.maths.realfunctions.ProxyMinimizer;
import ec.tstoolkit.maths.realfunctions.levmar.LevenbergMarquardtMethod;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.sarima.estimation.IterativeGlsSarimaMonitor;
import ec.tstoolkit.sarima.estimation.SarimaFixedMapping;
import ec.tstoolkit.sarima.estimation.SarimaInitializer;

public class IGlsEstimator
implements IRegArimaProcessor<SarimaModel> {
    public static final double DEF_EPS = 1.0E-7;
    private double eps_ = 1.0E-7;
    private boolean ml_ = true;
    private boolean usedefault = true;
    private Matrix pcov_;
    private final IParametricMapping<SarimaModel> mapping_;
    private ISsqFunctionMinimizer min_;

    public ISsqFunctionMinimizer getMinimizer() {
        return this.min_;
    }

    public void setMinimizer(ISsqFunctionMinimizer fmin) {
        this.min_ = fmin;
    }

    public boolean isMaximumLikelihood() {
        return this.ml_;
    }

    public boolean isUsingDefaultIfFailed() {
        return this.usedefault;
    }

    public void setUsingDefaultIfFailed(boolean usedef) {
        this.usedefault = usedef;
    }

    public void setMaximumLikelihood(boolean ml) {
        this.ml_ = ml;
    }

    public IGlsEstimator(IParametricMapping<SarimaModel> mapping) {
        LevenbergMarquardtMethod min = new LevenbergMarquardtMethod();
        this.min_ = min;
        this.mapping_ = mapping;
    }

    @Override
    public RegArimaEstimation<SarimaModel> process(RegArimaModel<SarimaModel> regs) {
        if (this.mapping_.getDim() == 0) {
            return this.compute(regs);
        }
        SarimaModel start = null;
        if (this.mapping_.getDim() == regs.getArima().getParametersCount()) {
            SarimaInitializer initializer = new SarimaInitializer();
            initializer.useDefaultIfFailed(this.usedefault);
            start = initializer.initialize(regs);
        }
        return this.optimize(regs, start);
    }

    @Override
    public double getPrecision() {
        return this.eps_;
    }

    @Override
    public RegArimaEstimation<SarimaModel> optimize(RegArimaModel<SarimaModel> regs) {
        if (this.mapping_.getDim() == 0) {
            return this.compute(regs);
        }
        return this.optimize(regs, regs.getArma());
    }

    private RegArimaEstimation<SarimaModel> compute(RegArimaModel<SarimaModel> regs) {
        return new RegArimaEstimation<SarimaModel>(regs, regs.computeLikelihood());
    }

    private RegArimaEstimation<SarimaModel> optimize(RegArimaModel<SarimaModel> regs, SarimaModel start) {
        IterativeGlsSarimaMonitor monitor = new IterativeGlsSarimaMonitor();
        monitor.useLogLikelihood(false);
        monitor.setMinimizer(new ProxyMinimizer(this.min_));
        monitor.setMapping(this.mapping_);
        monitor.setPrecision(this.eps_);
        RegArimaEstimation<SarimaModel> rslt = monitor.optimize(regs, start);
        if (rslt == null) {
            return null;
        }
        this.computepvar(monitor, rslt);
        return rslt;
    }

    @Override
    public void setPrecision(double value) {
        this.eps_ = value;
    }

    private void computepvar(IterativeGlsSarimaMonitor monitor, RegArimaEstimation<SarimaModel> rslt) {
        Matrix curvature = monitor.getCurvature();
        double svar = monitor.getMinimum() / (double)rslt.likelihood.getDegreesOfFreedom(false, 0);
        if (curvature == null) {
            return;
        }
        this.pcov_ = SymmetricMatrix.inverse(curvature);
        if (this.pcov_ == null) {
            return;
        }
        this.pcov_.mul(svar * 2.0);
        if (monitor.getMapping() instanceof SarimaFixedMapping) {
            SarimaFixedMapping mapping = (SarimaFixedMapping)monitor.getMapping();
            this.pcov_ = mapping.expandCovariance(this.pcov_);
        }
    }

    Matrix getParametersCovariance() {
        return this.pcov_;
    }
}

