/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.arima.estimation;

import ec.tstoolkit.arima.IArimaModel;
import ec.tstoolkit.arima.StationaryTransformation;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.maths.linearfilters.BackFilter;
import ec.tstoolkit.maths.matrices.Householder;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.MatrixException;
import ec.tstoolkit.maths.polynomials.Polynomial;

public class FastArimaML {
    private IArimaModel m_model;
    private IArimaModel m_stmodel;
    private BackFilter m_ur;
    private int m_ndata;
    private double[] m_res;
    private boolean m_bmean;
    private double m_dmean;
    private double m_detn;
    private double m_s2;

    private void clearresults() {
        this.m_res = null;
        this.m_detn = 0.0;
        this.m_dmean = 0.0;
        this.m_ndata = 0;
    }

    private void correctmean() {
        if (this.m_dmean == 0.0) {
            return;
        }
        Polynomial p = this.m_stmodel.getAR().getPolynomial();
        double c = 1.0;
        for (int i = 1; i <= p.getDegree(); ++i) {
            c += p.get(i);
        }
        this.m_dmean *= c;
    }

    public int degreesofFreedom(int np) {
        int df = this.m_ndata - this.m_model.getARCount();
        if (this.m_bmean) {
            --df;
        }
        return df - np;
    }

    public double getDeterminantalFactor() {
        return this.m_detn;
    }

    public double getDMean() {
        return this.m_dmean;
    }

    public IArimaModel getModel() {
        return this.m_model;
    }

    public double getObjective() {
        return this.m_s2 * this.m_detn;
    }

    public double[] getResiduals() {
        return this.m_res;
    }

    public double getSsqErr() {
        return this.m_s2;
    }

    public boolean isMeanCorrection() {
        return this.m_bmean;
    }

    public boolean process(DataBlock data) {
        if (this.m_model == null) {
            return false;
        }
        try {
            int i;
            int i2;
            int j;
            this.clearresults();
            this.m_ndata = data.getLength();
            DataBlock dy = new DataBlock(this.m_ndata - this.m_ur.getDegree());
            this.m_ur.filter(data, dy);
            this.m_dmean = 0.0;
            if (this.m_bmean) {
                this.m_dmean = dy.sum() / (double)dy.getLength();
            }
            this.correctmean();
            BackFilter phi = this.m_model.getAR();
            int p = phi.getDegree();
            double[] u = new double[this.m_ndata - p];
            DataBlock ru = new DataBlock(u);
            phi.filter(data, ru);
            if (this.m_dmean != 0.0) {
                ru.sub(this.m_dmean);
            }
            Polynomial theta = this.m_model.getMA().getPolynomial();
            int q = theta.getDegree();
            int n = this.m_ndata - p + q;
            double[] a = new double[n];
            for (int i3 = q; i3 < n; ++i3) {
                double s = u[i3 - q];
                for (j = 1; j <= q; ++j) {
                    if (theta.get(j) == 0.0) continue;
                    s -= theta.get(j) * a[i3 - j];
                }
                a[i3] = s;
            }
            double[] v = new double[n - q];
            System.arraycopy(a, q, v, 0, v.length);
            Matrix k = new Matrix(n, q);
            for (int i4 = 0; i4 < q; ++i4) {
                k.set(i4, i4, 1.0);
                for (j = q; j < n; ++j) {
                    double s = 0.0;
                    for (int l = 1; l <= theta.getDegree(); ++l) {
                        s -= k.get(j - l, i4) * theta.get(l);
                    }
                    k.set(j, i4, s);
                }
            }
            Householder qr = new Householder(false);
            qr.decompose(k);
            double[] q0 = qr.solve(a);
            for (i2 = 0; i2 < q; ++i2) {
                a[i2] = -q0[i2];
            }
            for (i2 = q; i2 < n; ++i2) {
                double sum = u[i2 - q];
                for (int j2 = 1; j2 <= q; ++j2) {
                    if (theta.get(j2) == 0.0) continue;
                    sum -= theta.get(j2) * a[i2 - j2];
                }
                a[i2] = sum;
            }
            double det = 1.0;
            DataBlock rdiag = qr.getRDiagonal();
            for (i = 0; i < rdiag.getLength(); ++i) {
                det *= rdiag.get(i) * rdiag.get(i);
            }
            this.m_s2 = 0.0;
            for (i = 0; i < a.length; ++i) {
                this.m_s2 += a[i] * a[i];
            }
            this.m_detn = Math.pow(det, 0.5 / (double)n);
            this.m_res = a;
            return true;
        }
        catch (MatrixException ex) {
            this.clearresults();
            return false;
        }
    }

    public double ser(int np) {
        return Math.sqrt(this.m_s2 / (double)this.degreesofFreedom(np));
    }

    public void setMeanCorrection(boolean value) {
        if (this.m_bmean != value) {
            this.clearresults();
            this.m_bmean = value;
        }
    }

    public void setModel(IArimaModel value) {
        if (value != this.m_model) {
            this.m_model = value;
            StationaryTransformation st = this.m_model.stationaryTransformation();
            this.m_ur = st.unitRoots;
            this.m_stmodel = (IArimaModel)st.stationaryModel;
            this.clearresults();
        }
    }
}

