## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment  = "#>"
)
library(MRTAnalysis)

## ----load-example-data--------------------------------------------------------
data("data_example_for_standardized_effect")
dat <- data_example_for_standardized_effect
head(dat)

## ----estimate-effect----------------------------------------------------------
ans_ci <- calculate_mrt_effect_size(
  data         = dat,
  id           = "id",
  outcome      = "outcome",
  treatment    = "treatment",
  time         = "decision_point",
  rand_prob    = "prob_treatment",
  availability = "availability",
  covariates   = "covariate1",
  do_bootstrap = TRUE,
  boot_replications = 100
)

head(ans_ci)

## ----summary------------------------------------------------------------------
summary(ans_ci)

## ----bootstrap-example, eval=FALSE--------------------------------------------
# ans_ci <- calculate_mrt_effect_size(
#   data         = dat,
#   id           = "id",
#   outcome      = "outcome",
#   treatment    = "treatment",
#   time         = "decision_point",
#   rand_prob    = "prob_treatment",
#   availability = "availability",
#   covariates   = "covariate1",
#   do_bootstrap = TRUE,
#   boot_replications = 1000
# )

## ----plot-effect, fig.width=6, fig.height=4-----------------------------------
plot(ans_ci)

