## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(LipinskiFilters)

## -----------------------------------------------------------------------------
file<-system.file("extdata", "test.sdf", package = "LipinskiFilters")

## -----------------------------------------------------------------------------
mols<-load.molecules(file)

## -----------------------------------------------------------------------------
properties <- compute_properties(mols)
print(properties)

## -----------------------------------------------------------------------------
create_lipinski_plots(properties)

## -----------------------------------------------------------------------------
assess_drug_likeness(properties)

## -----------------------------------------------------------------------------
predict_oral_bioavailability(properties)

