## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(ChileDataAPI)
library(ggplot2)
library(dplyr)

## ----chile-copper,echo = TRUE,message = FALSE,warning = FALSE,results = 'markup'----


chile_copper_price <- head(get_chile_copper_pound(),n=10)

print(chile_copper_price)



## ----chile-dollar,echo = TRUE,message = FALSE,warning = FALSE,results = 'markup'----


chile_dollar_price <- head(get_chile_dollar(),n=10)

print(chile_dollar_price)



## ----chile-euro,echo = TRUE,message = FALSE,warning = FALSE,results = 'markup'----


chile_euro_price <- head(get_chile_euro(),n=10)

print(chile_euro_price)



## ----chile-gdp,echo = TRUE,message = FALSE,warning = FALSE,results = 'markup'----


chile_gdp <- head(get_chile_gdp())

print(chile_gdp)


## ----chile-life-expectancy,echo = TRUE,message = FALSE,warning = FALSE,results = 'markup'----

chile_life_expectancy <- head(get_chile_life_expectancy())

print(chile_life_expectancy)


## ----chile-health-plot, message=FALSE, warning=FALSE, fig.width=7, fig.height=5----

# Clean data: remove missing values from key variables
health_clean <- chile_health_survey_df %>%
  filter(!is.na(age), !is.na(pas), !is.na(male))

# Create gender variable
health_clean <- health_clean %>%
  mutate(gender = ifelse(male == 1, "Male", "Female"))

# Plot: Systolic Blood Pressure vs Age by Gender
ggplot(health_clean, aes(x = age, y = pas, color = gender)) +
  geom_point(alpha = 0.4) +
  geom_smooth(method = "lm", se = FALSE) +
  labs(
    title = "Systolic Blood Pressure (PAS) by Age and Gender",
    x = "Age (years)",
    y = "Systolic Blood Pressure (mm Hg)",
    color = "Gender"
  ) +
  theme_minimal()


