/*
 * Decompiled with CFR 0.152.
 */
package jdplus.x13.base.core.x13.regarima;

import jdplus.toolkit.base.core.arima.estimation.ArmaFilter;
import jdplus.toolkit.base.core.arima.estimation.ResidualsComputer;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.regarima.IRegArimaComputer;
import jdplus.toolkit.base.core.regarima.outlier.CriticalValueComputer;
import jdplus.toolkit.base.core.regsarima.RegSarimaComputer;
import jdplus.toolkit.base.core.sarima.SarimaModel;
import lombok.Generated;

public final class X13Utility {
    public static final double MINCV = 2.8;

    public static double calcCv(int nobs) {
        return Math.max(CriticalValueComputer.advancedComputer().applyAsDouble(nobs), 2.8);
    }

    public static IRegArimaComputer<SarimaModel> processor(boolean ml, double precision) {
        return RegSarimaComputer.builder().useMaximumLikelihood(ml).precision(precision).startingPoint(RegSarimaComputer.StartingPoint.Multiple).build();
    }

    public static ResidualsComputer mlComputer() {
        return (arma, y) -> {
            ArmaFilter f = ArmaFilter.ljungBox((boolean)true);
            int n = y.length();
            int nf = f.prepare(arma, n);
            DataBlock fres = DataBlock.make((int)nf);
            f.apply(y, fres);
            return nf == n ? fres : fres.drop(nf - n, 0);
        };
    }

    @Generated
    private X13Utility() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

