/*
 * Decompiled with CFR 0.152.
 */
package jdplus.x13.base.core.x11.extremevaluecorrector;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.stats.ProbabilityType;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.dstats.F;
import jdplus.x13.base.core.x11.X11Context;
import lombok.Generated;

public class Cochran {
    private final DataBlock input;
    private final boolean isMulti;
    private final int period;
    private final double[] standardDeviation;
    private double testValue;
    private double criticalValue;
    private boolean result = true;
    private int minNumberOfYears = 0;
    private static final double[] T12 = new double[]{0.541, 0.3934, 0.3264, 0.288, 0.2624, 0.2439, 0.2299, 0.2187, 0.2098, 0.202, 0.198, 0.194, 0.186, 0.182, 0.178, 0.174, 0.17, 0.166, 0.162, 0.158, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.1403, 0.14, 0.14, 0.14, 0.14};
    private static final double[] T4 = new double[]{0.9065, 0.7679, 0.6841, 0.6287, 0.5895, 0.5598, 0.5365, 0.5175, 0.5017, 0.4884, 0.48, 0.471, 0.463, 0.454, 0.445, 0.4366, 0.433, 0.43, 0.427, 0.424, 0.421, 0.417, 0.414, 0.411, 0.408, 0.404, 0.401, 0.398, 0.395, 0.391, 0.388, 0.385, 0.382, 0.379, 0.375, 0.372, 0.369, 0.366, 0.362, 0.359};
    private static final double[] T2 = new double[]{0.9985, 0.975, 0.9392, 0.9057, 0.8772, 0.8534, 0.8332, 0.8159, 0.801, 0.788, 0.7765, 0.7662, 0.757, 0.7487, 0.7411, 0.7341, 0.7278, 0.7219, 0.7164, 0.7114, 0.7066, 0.7022, 0.698, 0.6941, 0.6904, 0.6869, 0.6836, 0.6805, 0.6775, 0.6747, 0.672, 0.6694, 0.6669, 0.6646, 0.6623, 0.6601, 0.658, 0.656, 0.6541, 0.6522};

    public Cochran(DoubleSeq ds, X11Context context) {
        this.input = DataBlock.of((DoubleSeq)ds);
        this.isMulti = context.isMultiplicative();
        this.period = context.getPeriod();
        this.standardDeviation = new double[this.period];
        this.calcCochranTest();
    }

    private double C(int numberOfYears) {
        F f = new F((double)(numberOfYears + 1), (double)((this.period - 1) * (numberOfYears + 1)));
        double C = 1.0 / (1.0 + ((double)this.period - 1.0) / f.getProbabilityInverse(0.05 / (double)this.period, ProbabilityType.Upper));
        return C;
    }

    private void calcCochranTest() {
        this.testValue = 0.0;
        double smax = -10.0;
        int nmin = 100;
        double st = this.isMulti ? 1.0 : 0.0;
        for (int i = 0; i <= this.period - 1; ++i) {
            DataBlock dsPeriod = this.input.extract(i, -1, this.period);
            this.standardDeviation[i] = 0.0;
            this.standardDeviation[i] = dsPeriod.ssqcWithMissing(st);
            int n1 = dsPeriod.count(y -> !Double.isNaN(y));
            this.standardDeviation[i] = this.standardDeviation[i] / (double)n1;
            if (nmin > n1 - 2) {
                nmin = n1 - 2;
            }
            if (smax < this.standardDeviation[i]) {
                smax = this.standardDeviation[i];
            }
            this.testValue += this.standardDeviation[i];
        }
        if (this.testValue != 0.0) {
            this.testValue = smax / this.testValue;
        }
        this.minNumberOfYears = nmin + 1;
        if (nmin > 39) {
            nmin = 39;
        }
        switch (this.period) {
            case 12: {
                this.criticalValue = T12[nmin];
                break;
            }
            case 4: {
                this.criticalValue = T4[nmin];
                break;
            }
            case 2: {
                this.criticalValue = T2[nmin];
                break;
            }
            default: {
                this.criticalValue = this.C(nmin);
            }
        }
        if (this.testValue >= this.criticalValue) {
            this.result = false;
        }
    }

    public boolean getTestResult() {
        return this.result;
    }

    @Generated
    double[] getStandardDeviation() {
        return this.standardDeviation;
    }

    @Generated
    public double getTestValue() {
        return this.testValue;
    }

    @Generated
    public double getCriticalValue() {
        return this.criticalValue;
    }

    @Generated
    public int getMinNumberOfYears() {
        return this.minNumberOfYears;
    }
}

