/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.com.github.rzymek.opczip.reader.ordered;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.Map;
import standalone_spreadsheet.com.github.rzymek.opczip.reader.ordered.OrderedZipStreamReader;

public class MemCacheOrderedZipStreamReader
extends OrderedZipStreamReader {
    private Map<String, byte[]> cache = new HashMap<String, byte[]>();

    @Override
    protected OutputStream getTempOutputStream(final String name) {
        return new ByteArrayOutputStream(){

            @Override
            public void close() throws IOException {
                super.close();
                MemCacheOrderedZipStreamReader.this.cache.put(name, this.toByteArray());
            }
        };
    }

    @Override
    protected InputStream getTempInputStream(String name) throws UncheckedIOException {
        byte[] buf = this.cache.get(name);
        if (buf == null) {
            throw new IllegalStateException("No cache for " + name);
        }
        return new ByteArrayInputStream(buf);
    }
}

