/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.extension.nary;

import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.memory.IStateLong;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.constraints.extension.Tuples;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.IIntDeltaMonitor;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.procedure.UnaryIntProcedure;

public class PropCompactTable
extends Propagator<IntVar> {
    RSparseBitSet currTable;
    protected Tuples tuples;
    protected long[][][] supports;
    int[][] residues;
    protected int[] offset;
    protected IIntDeltaMonitor[] monitors;
    private final UnaryIntProcedure<Integer> onValRem;

    public PropCompactTable(IntVar[] vars, Tuples tuples) {
        super((Variable[])vars, (Priority)PropagatorPriority.QUADRATIC, true);
        this.tuples = tuples;
        this.currTable = new RSparseBitSet(this.model.getEnvironment(), this.tuples.nbTuples());
        this.computeSupports(tuples);
        this.monitors = new IIntDeltaMonitor[vars.length];
        for (int i = 0; i < vars.length; ++i) {
            this.monitors[i] = vars[i].monitorDelta(this);
        }
        this.onValRem = this.makeProcedure();
    }

    protected UnaryIntProcedure<Integer> makeProcedure() {
        return new UnaryIntProcedure<Integer>(){
            int var;
            int off;

            @Override
            public UnaryIntProcedure<Integer> set(Integer o) {
                this.var = o;
                this.off = PropCompactTable.this.offset[this.var];
                return this;
            }

            @Override
            public void execute(int i) {
                PropCompactTable.this.currTable.addToMask(PropCompactTable.this.supports[this.var][i - this.off]);
            }
        };
    }

    protected void computeSupports(Tuples tuples) {
        int n = ((IntVar[])this.vars).length;
        this.offset = new int[n];
        this.supports = new long[n][][];
        this.residues = new int[n][];
        for (int i = 0; i < n; ++i) {
            int lb = ((IntVar[])this.vars)[i].getLB();
            int ub = ((IntVar[])this.vars)[i].getUB();
            this.offset[i] = lb;
            this.supports[i] = new long[ub - lb + 1][this.currTable.words.length];
            this.residues[i] = new int[ub - lb + 1];
        }
        int wI = 0;
        int bI = 63;
        block1: for (int ti = 0; ti < tuples.nbTuples(); ++ti) {
            int i;
            int[] tuple = tuples.get(ti);
            for (i = 0; i < tuple.length; ++i) {
                if (!((IntVar[])this.vars)[i].contains(tuple[i])) continue block1;
            }
            for (i = 0; i < tuple.length; ++i) {
                long[] tmp = this.supports[i][tuple[i] - this.offset[i]];
                int n2 = wI;
                tmp[n2] = tmp[n2] | 1L << bI;
            }
            if ((bI = (int)((byte)(bI - 1))) >= 0) continue;
            bI = 63;
            ++wI;
        }
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (PropagatorEventType.isFullPropagation(evtmask)) {
            int i;
            for (i = 0; i < ((IntVar[])this.vars).length; ++i) {
                this.currTable.clearMask();
                int ub = ((IntVar[])this.vars)[i].getUB();
                int v = ((IntVar[])this.vars)[i].getLB();
                while (v <= ub) {
                    this.currTable.addToMask(this.supports[i][v - this.offset[i]]);
                    v = ((IntVar[])this.vars)[i].nextValue(v);
                }
                this.currTable.intersectWithMask();
            }
            for (i = 0; i < ((IntVar[])this.vars).length; ++i) {
                this.monitors[i].startMonitoring();
            }
        }
        this.filterDomains();
    }

    @Override
    public void propagate(int vIdx, int mask) throws ContradictionException {
        this.currTable.clearMask();
        if (((IntVar[])this.vars)[vIdx].getDomainSize() > this.monitors[vIdx].sizeApproximation()) {
            this.monitors[vIdx].forEachRemVal(this.onValRem.set(vIdx));
            this.currTable.reverseMask();
        } else {
            int ub = ((IntVar[])this.vars)[vIdx].getUB();
            int v = ((IntVar[])this.vars)[vIdx].getLB();
            while (v <= ub) {
                this.currTable.addToMask(this.supports[vIdx][v - this.offset[vIdx]]);
                v = ((IntVar[])this.vars)[vIdx].nextValue(v);
            }
        }
        this.currTable.intersectWithMask();
        if (this.currTable.isEmpty()) {
            this.fails();
        }
        this.forcePropagate(PropagatorEventType.CUSTOM_PROPAGATION);
    }

    private void filterDomains() throws ContradictionException {
        if (this.currTable.isEmpty()) {
            this.fails();
        }
        for (int i = 0; i < ((IntVar[])this.vars).length; ++i) {
            if (((IntVar[])this.vars)[i].hasEnumeratedDomain()) {
                this.enumFilter(i);
                continue;
            }
            this.boundFilter(i);
        }
    }

    private void boundFilter(int i) throws ContradictionException {
        int index;
        int v;
        int lb = ((IntVar[])this.vars)[i].getLB();
        int ub = ((IntVar[])this.vars)[i].getUB();
        for (v = lb; v <= ub && (this.currTable.words[index = this.residues[i][v - this.offset[i]]].get() & this.supports[i][v - this.offset[i]][index]) == 0L; ++v) {
            index = this.currTable.intersectIndex(this.supports[i][v - this.offset[i]]);
            if (index == -1) {
                ++lb;
                continue;
            }
            this.residues[i][v - this.offset[i]] = index;
            break;
        }
        ((IntVar[])this.vars)[i].updateLowerBound(lb, (ICause)this);
        for (v = ub; v >= lb && (this.currTable.words[index = this.residues[i][v - this.offset[i]]].get() & this.supports[i][v - this.offset[i]][index]) == 0L; --v) {
            index = this.currTable.intersectIndex(this.supports[i][v - this.offset[i]]);
            if (index == -1) {
                --ub;
                continue;
            }
            this.residues[i][v - this.offset[i]] = index;
            break;
        }
        ((IntVar[])this.vars)[i].updateUpperBound(ub, (ICause)this);
    }

    private void enumFilter(int i) throws ContradictionException {
        int ub = ((IntVar[])this.vars)[i].getUB();
        int v = ((IntVar[])this.vars)[i].getLB();
        while (v <= ub) {
            int index = this.residues[i][v - this.offset[i]];
            if ((this.currTable.words[index].get() & this.supports[i][v - this.offset[i]][index]) == 0L) {
                index = this.currTable.intersectIndex(this.supports[i][v - this.offset[i]]);
                if (index == -1) {
                    ((IntVar[])this.vars)[i].removeValue(v, (ICause)this);
                } else {
                    this.residues[i][v - this.offset[i]] = index;
                }
            }
            v = ((IntVar[])this.vars)[i].nextValue(v);
        }
    }

    @Override
    public ESat isEntailed() {
        return this.tuples.check((IntVar[])this.vars);
    }

    protected static class RSparseBitSet {
        protected IStateLong[] words;
        private final int[] index;
        private final IStateInt limit;
        private final long[] mask;

        protected RSparseBitSet(IEnvironment environment, int nbBits) {
            int nw = nbBits / 64;
            if (nw * 64 < nbBits) {
                ++nw;
            }
            this.index = new int[nw];
            this.mask = new long[nw];
            this.limit = environment.makeInt(nw - 1);
            this.words = new IStateLong[nw];
            for (int i = 0; i < nw; ++i) {
                this.index[i] = i;
                this.words[i] = environment.makeLong(-1L);
            }
        }

        private boolean isEmpty() {
            return this.limit.get() == -1;
        }

        protected void clearMask() {
            for (int i = this.limit.get(); i >= 0; --i) {
                int offset = this.index[i];
                this.mask[offset] = 0L;
            }
        }

        protected void reverseMask() {
            for (int i = this.limit.get(); i >= 0; --i) {
                int offset = this.index[i];
                this.mask[offset] = this.mask[offset] ^ 0xFFFFFFFFFFFFFFFFL;
            }
        }

        protected void addToMask(long[] wordsToAdd) {
            for (int i = this.limit.get(); i >= 0; --i) {
                int offset = this.index[i];
                this.mask[offset] = this.mask[offset] | wordsToAdd[offset];
            }
        }

        private void intersectWithMask() {
            for (int i = this.limit.get(); i >= 0; --i) {
                int offset = this.index[i];
                long w = this.words[offset].get() & this.mask[offset];
                if (this.words[offset].get() == w) continue;
                this.words[offset].set(w);
                if (w != 0L) continue;
                this.index[i] = this.index[this.limit.get()];
                this.index[this.limit.get()] = offset;
                this.limit.add(-1);
            }
        }

        private int intersectIndex(long[] m) {
            for (int i = this.limit.get(); i >= 0; --i) {
                int offset = this.index[i];
                if ((this.words[offset].get() & m[offset]) == 0L) continue;
                return offset;
            }
            return -1;
        }
    }
}

