/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.preprocessor;

import choco.cp.common.util.preprocessor.ExpressionTools;
import choco.cp.solver.CPModelToCPSolver;
import choco.cp.solver.CPSolver;
import choco.cp.solver.constraints.reified.ExpressionSConstraint;
import choco.kernel.model.constraints.Constraint;
import choco.kernel.model.constraints.MetaConstraint;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.constraints.reified.BoolNode;
import gnu.trove.TLongObjectHashMap;

public class PPModelToCPSolver
extends CPModelToCPSolver {
    protected TLongObjectHashMap<ExpressionSConstraint> knownExpressionCts = new TLongObjectHashMap();
    protected int nbHeavyBin = 0;

    public PPModelToCPSolver(CPSolver cpsolver) {
        super(cpsolver);
    }

    public void storeExpressionSConstraint(Constraint c, ExpressionSConstraint ic) {
        this.knownExpressionCts.put(c.getIndex(), ic);
    }

    @Override
    protected SConstraint createMetaConstraint(Constraint ic, Boolean decomp) {
        try {
            ExpressionSConstraint c = this.knownExpressionCts.get(ic.getIndex());
            if (c == null) {
                c = new ExpressionSConstraint(super.buildBoolNode(ic));
            }
            c.setScope(this.cpsolver);
            c.setDecomposeExp(decomp);
            if (decomp == null && ExpressionTools.toBeDecomposed(c)) {
                c.setDecomposeExp(true);
            } else if (ExpressionTools.isVeryBinaryHeavy(c)) {
                ++this.nbHeavyBin;
            }
            if (ic.getOptions().contains("cp:ac")) {
                c.setLevelAc(0);
            } else if (ic.getOptions().contains("cp:fc")) {
                c.setLevelAc(1);
            } else if (this.nbHeavyBin > 2000) {
                c.setLevelAc(1);
            } else {
                c.setLevelAc(0);
            }
            SConstraint intensional = c.getKnownIntensionalConstraint();
            if (intensional == null) {
                intensional = ExpressionTools.getIntentionalConstraint(c, this.cpsolver);
            }
            if (intensional != null) {
                return intensional;
            }
            return c;
        }
        catch (ClassCastException cce) {
            LOGGER.info("createGenericMetaConstraint");
            return this.createGenericMetaConstraint((MetaConstraint)ic, decomp);
        }
    }

    public BoolNode buildNode(Constraint ic) {
        return super.buildBoolNode(ic);
    }

    protected void readBBDecisionVariables() {
        super.readDecisionVariables();
    }
}

