## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(enaho)

## -----------------------------------------------------------------------------
dir <- system.file("extdata", package = "enaho") # directorio con las bases
leido <- leer.inei(modulo = 37,periodos = 2011,tipo = c("t1"),directorio = dir)
leido

## -----------------------------------------------------------------------------
media.inei(x = "P7061", base = leido, pesos = "FACTRIM")

## -----------------------------------------------------------------------------
media.inei(x = "P7061",base = leido, pesos = "FACTRIM",
                 estratos = "DOMINIO")

## -----------------------------------------------------------------------------
media.inei(x = "P7061",base = leido, pesos = "FACTRIM",
                 estratos = "region")

## -----------------------------------------------------------------------------
media.inei(x = "P7061",base = leido, pesos = "FACTRIM",
                 estratos = "area")

## -----------------------------------------------------------------------------
media.inei(x = "P7061",base = leido, pesos = "FACTRIM",
                 estratos = "area",
                 ruralidad = 7:8)

## -----------------------------------------------------------------------------
media.inei(x = "P7061",base = leido, pesos = "FACTRIM",
                 estratos = c("area","DOMINIO"))

## -----------------------------------------------------------------------------
media.inei(x = "P7061",base = leido, pesos = "FACTRIM",
                 estratos = c("area","DOMINIO"),
                 combinarestratos = TRUE)

## -----------------------------------------------------------------------------
leido2 <- leer.inei(modulo = 37,periodos = c(2011,2024),tipo = c("t1"),directorio = dir,
                   combinar = TRUE)
class(leido2)

## -----------------------------------------------------------------------------
media.inei(x = "P7061", base = leido2, pesos = NULL)

## ----error=TRUE---------------------------------------------------------------
try({
media.inei(x = "P7061", base = leido2, pesos = "FACTRIM")
})

## ----error=FALSE--------------------------------------------------------------
media.inei(x = "P7061", base = leido2, pesos = c("FACTRIM","FACTOR"),)

## ----error=FALSE--------------------------------------------------------------
media.inei(x = c("P7061","P7062"), base = leido2, pesos = c("FACTRIM","FACTOR"),
                 estratos = "area")

## -----------------------------------------------------------------------------
media.inei(x = "P7061", base = leido, pesos = "FACTRIM",
            var = "insesgado")

## -----------------------------------------------------------------------------
media.inei(x = "P7061", base = leido, pesos = "FACTRIM",
            var = "MV")

## -----------------------------------------------------------------------------
media.inei(x = "P7061", base = leido, pesos = "FACTRIM",
                 decimales = 3)

