### some further examples:
require(distrMod)
options("newDevice"=TRUE)


### Beta Family
B <- BetaFamily(2,4)
# generate data
x <- r(B)(40)
distroptions(DistrResolution = 1e-10)

MDEstimator(x, B, distance = TotalVarDist)

#Evaluations of Minimum total variation distance estimate:
#---------------------------------------------------------
#An object of class Estimate
#generated by call
#  MDEstimator(x = x, ParamFamily = B, distance = TotalVarDist)
#samplesize:   40
#estimate:
#  shape1   shape2
#3.218402 6.134194
#Criterion:
#total variation distance
#               0.7993998

MDEstimator(x, B)

#Evaluations of Minimum Kolmogorov distance estimate:
#----------------------------------------------------
#An object of class Estimate
#generated by call
#  MDEstimator(x = x, ParamFamily = B)
#samplesize:   40
#estimate:
#  shape1   shape2
#1.419884 2.540196
#Criterion:
#Kolmogorov distance
#         0.07407411

MDEstimator(x, B, distance = CvMDist, asvar.fct = distrMod:::.CvMMDCovariance)

#Evaluations of Minimum CvM distance estimate:
#---------------------------------------------
#An object of class Estimate
#generated by call
#  MDEstimator(x = x, ParamFamily = B, distance = CvMDist, asvar.fct = distrMod:::.CvMMDCovariance)
#samplesize:   40
#estimate:
#    shape1      shape2
#  1.4895092   2.6895131
# (0.3850902) (0.7462670)
#asymptotic (co)variance (multiplied with samplesize):
#         shape1    shape2
#shape1 5.931779  8.230865
#shape2 8.230865 22.276575
#Criterion:
#CvM distance
#  0.03256456

(MLE<-MLEstimator(x, B))

#Evaluations of Maximum likelihood estimate:
#-------------------------------------------
#An object of class Estimate
#generated by call
#  MLEstimator(x = x, ParamFamily = B)
#samplesize:   40
#estimate:
#    shape1      shape2
#  1.6057134   2.9312042
# (0.3320569) (0.6485889)
#asymptotic (co)variance (multiplied with samplesize):
#         shape1    shape2
#shape1 4.410470  6.821746
#shape2 6.821746 16.826704
#Criterion:
#negative log-likelihood
#              -9.920826

confint(MLE)

#A[n] asymptotic (CLT-based) confidence interval:
#          2.5 %   97.5 %
#shape1 0.954894 2.256533
#shape2 1.659993 4.202415
#Type of estimator: Maximum likelihood estimate
#samplesize:   40
#Call by which estimate was produced:
#MLEstimator(x = x, ParamFamily = B)








