/*
 * Decompiled with CFR 0.152.
 */
package moa.streams;

import moa.core.InstancesHeader;
import moa.core.ObjectRepository;
import moa.options.AbstractOptionHandler;
import moa.options.ClassOption;
import moa.options.ListOption;
import moa.options.Option;
import moa.options.OptionHandler;
import moa.streams.InstanceStream;
import moa.streams.filters.StreamFilter;
import moa.tasks.TaskMonitor;
import weka.core.Instance;

public class FilteredStream
extends AbstractOptionHandler
implements InstanceStream {
    private static final long serialVersionUID = 1L;
    public ClassOption streamOption = new ClassOption("stream", 's', "Stream to filter.", InstanceStream.class, "generators.RandomTreeGenerator");
    public ListOption filtersOption = new ListOption("filters", 'f', "Filters to apply.", new ClassOption("filter", ' ', "Stream filter.", StreamFilter.class, "AddNoiseFilter"), new Option[0], ',');
    protected InstanceStream filterChain;

    public String getPurposeString() {
        return "A stream that is filtered.";
    }

    public void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
        Option[] filterOptions = this.filtersOption.getList();
        StreamFilter[] filters = new StreamFilter[filterOptions.length];
        for (int i = 0; i < filters.length; ++i) {
            monitor.setCurrentActivity("Materializing filter " + (i + 1) + "...", -1.0);
            filters[i] = (StreamFilter)((ClassOption)filterOptions[i]).materializeObject(monitor, repository);
            if (monitor.taskShouldAbort()) {
                return;
            }
            if (!(filters[i] instanceof OptionHandler)) continue;
            monitor.setCurrentActivity("Preparing filter " + (i + 1) + "...", -1.0);
            ((OptionHandler)((Object)filters[i])).prepareForUse(monitor, repository);
            if (!monitor.taskShouldAbort()) continue;
            return;
        }
        InstanceStream chain = (InstanceStream)this.getPreparedClassOption(this.streamOption);
        for (int i = 0; i < filters.length; ++i) {
            filters[i].setInputStream(chain);
            chain = filters[i];
        }
        this.filterChain = chain;
    }

    public long estimatedRemainingInstances() {
        return this.filterChain.estimatedRemainingInstances();
    }

    public InstancesHeader getHeader() {
        return this.filterChain.getHeader();
    }

    public boolean hasMoreInstances() {
        return this.filterChain.hasMoreInstances();
    }

    public boolean isRestartable() {
        return this.filterChain.isRestartable();
    }

    public Instance nextInstance() {
        return this.filterChain.nextInstance();
    }

    public void restart() {
        this.filterChain.restart();
    }

    public void getDescription(StringBuilder sb, int indent) {
    }
}

