/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.ContingencyTables;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class ConjunctiveRule
extends Classifier
implements OptionHandler,
WeightedInstancesHandler {
    static final long serialVersionUID = -5938309903225087198L;
    private int m_Folds = 3;
    private Attribute m_ClassAttribute;
    protected FastVector m_Antds = null;
    protected double[] m_DefDstr = null;
    protected double[] m_Cnsqt = null;
    private int m_NumClasses = 0;
    private long m_Seed = 1L;
    private Random m_Random = null;
    private FastVector m_Targets;
    private boolean m_IsExclude = false;
    private double m_MinNo = 2.0;
    private int m_NumAntds = -1;

    public String globalInfo() {
        return "This class implements a single conjunctive rule learner that can predict for numeric and nominal class labels.\n\nA rule consists of antecedents \"AND\"ed together and the consequent (class value) for the classification/regression.  In this case, the consequent is the distribution of the available classes (or mean for a numeric value) in the dataset. If the test instance is not covered by this rule, then it's predicted using the default class distributions/value of the data not covered by the rule in the training data.This learner selects an antecedent by computing the Information Gain of each antecendent and prunes the generated rule using Reduced Error Prunning (REP) or simple pre-pruning based on the number of antecedents.\n\nFor classification, the Information of one antecedent is the weighted average of the entropies of both the data covered and not covered by the rule.\nFor regression, the Information is the weighted average of the mean-squared errors of both the data covered and not covered by the rule.\n\nIn pruning, weighted average of the accuracy rates on the pruning data is used for classification while the weighted average of the mean-squared errors on the pruning data is used for regression.\n\n";
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(6);
        vector.addElement(new Option("\tSet number of folds for REP\n\tOne fold is used as pruning set.\n\t(default 3)", "N", 1, "-N <number of folds>"));
        vector.addElement(new Option("\tSet if NOT uses randomization\n\t(default:use randomization)", "R", 0, "-R"));
        vector.addElement(new Option("\tSet whether consider the exclusive\n\texpressions for nominal attributes\n\t(default false)", "E", 0, "-E"));
        vector.addElement(new Option("\tSet the minimal weights of instances\n\twithin a split.\n\t(default 2.0)", "M", 1, "-M <min. weights>"));
        vector.addElement(new Option("\tSet number of antecedents for pre-pruning\n\tif -1, then REP is used\n\t(default -1)", "P", 1, "-P <number of antecedents>"));
        vector.addElement(new Option("\tSet the seed of randomization\n\t(default 1)", "S", 1, "-S <seed>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('N', stringArray);
        this.m_Folds = string.length() != 0 ? Integer.parseInt(string) : 3;
        String string2 = Utils.getOption('M', stringArray);
        this.m_MinNo = string2.length() != 0 ? Double.parseDouble(string2) : 2.0;
        String string3 = Utils.getOption('S', stringArray);
        this.m_Seed = string3.length() != 0 ? (long)Integer.parseInt(string3) : 1L;
        String string4 = Utils.getOption('P', stringArray);
        this.m_NumAntds = string4.length() != 0 ? Integer.parseInt(string4) : -1;
        this.m_IsExclude = Utils.getFlag('E', stringArray);
    }

    public String[] getOptions() {
        String[] stringArray = new String[9];
        int n = 0;
        stringArray[n++] = "-N";
        stringArray[n++] = "" + this.m_Folds;
        stringArray[n++] = "-M";
        stringArray[n++] = "" + this.m_MinNo;
        stringArray[n++] = "-P";
        stringArray[n++] = "" + this.m_NumAntds;
        stringArray[n++] = "-S";
        stringArray[n++] = "" + this.m_Seed;
        if (this.m_IsExclude) {
            stringArray[n++] = "-E";
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public String foldsTipText() {
        return "Determines the amount of data used for pruning. One fold is used for pruning, the rest for growing the rules.";
    }

    public void setFolds(int n) {
        this.m_Folds = n;
    }

    public int getFolds() {
        return this.m_Folds;
    }

    public String seedTipText() {
        return "The seed used for randomizing the data.";
    }

    public void setSeed(long l) {
        this.m_Seed = l;
    }

    public long getSeed() {
        return this.m_Seed;
    }

    public String exclusiveTipText() {
        return "Set whether to consider exclusive expressions for nominal attribute splits.";
    }

    public boolean getExclusive() {
        return this.m_IsExclude;
    }

    public void setExclusive(boolean bl) {
        this.m_IsExclude = bl;
    }

    public String minNoTipText() {
        return "The minimum total weight of the instances in a rule.";
    }

    public void setMinNo(double d) {
        this.m_MinNo = d;
    }

    public double getMinNo() {
        return this.m_MinNo;
    }

    public String numAntdsTipText() {
        return "Set the number of antecedents allowed in the rule if pre-pruning is used.  If this value is other than -1, then pre-pruning will be used, otherwise the rule uses reduced-error pruning.";
    }

    public void setNumAntds(int n) {
        this.m_NumAntds = n;
    }

    public int getNumAntds() {
        return this.m_NumAntds;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        capabilities.enable(Capabilities.Capability.NUMERIC_CLASS);
        capabilities.enable(Capabilities.Capability.DATE_CLASS);
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return capabilities;
    }

    public void buildClassifier(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        Instances instances2 = new Instances(instances);
        instances2.deleteWithMissingClass();
        if (instances2.numInstances() < this.m_Folds) {
            throw new Exception("Not enough data for REP.");
        }
        this.m_ClassAttribute = instances2.classAttribute();
        this.m_NumClasses = this.m_ClassAttribute.isNominal() ? this.m_ClassAttribute.numValues() : 1;
        this.m_Antds = new FastVector();
        this.m_DefDstr = new double[this.m_NumClasses];
        this.m_Cnsqt = new double[this.m_NumClasses];
        this.m_Targets = new FastVector();
        this.m_Random = new Random(this.m_Seed);
        if (this.m_NumAntds != -1) {
            this.grow(instances2);
        } else {
            instances2.randomize(this.m_Random);
            instances2.stratify(this.m_Folds);
            Instances instances3 = instances2.trainCV(this.m_Folds, this.m_Folds - 1, this.m_Random);
            Instances instances4 = instances2.testCV(this.m_Folds, this.m_Folds - 1);
            this.grow(instances3);
            this.prune(instances4);
        }
        if (this.m_ClassAttribute.isNominal()) {
            Utils.normalize(this.m_Cnsqt);
            if (Utils.gr(Utils.sum(this.m_DefDstr), 0.0)) {
                Utils.normalize(this.m_DefDstr);
            }
        }
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        if (instance == null) {
            throw new Exception("Testing instance is NULL!");
        }
        if (this.isCover(instance)) {
            return this.m_Cnsqt;
        }
        return this.m_DefDstr;
    }

    public boolean isCover(Instance instance) {
        boolean bl = true;
        for (int i = 0; i < this.m_Antds.size(); ++i) {
            Antd antd = (Antd)this.m_Antds.elementAt(i);
            if (antd.isCover(instance)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public boolean hasAntds() {
        if (this.m_Antds == null) {
            return false;
        }
        return this.m_Antds.size() > 0;
    }

    private void grow(Instances instances) {
        Instances instances2 = new Instances(instances);
        double d = instances.sumOfWeights();
        if (this.m_NumAntds != 0) {
            int n;
            double d2;
            Instance instance;
            int n2;
            double[][] dArray = new double[2][this.m_NumClasses];
            for (n2 = 0; n2 < this.m_NumClasses; ++n2) {
                dArray[0][n2] = 0.0;
                dArray[1][n2] = 0.0;
            }
            if (this.m_ClassAttribute.isNominal()) {
                for (n2 = 0; n2 < instances2.numInstances(); ++n2) {
                    instance = instances2.instance(n2);
                    double[] dArray2 = dArray[0];
                    int n3 = (int)instance.classValue();
                    dArray2[n3] = dArray2[n3] + instance.weight();
                }
                d2 = ContingencyTables.entropy(dArray[0]);
            } else {
                for (n2 = 0; n2 < instances2.numInstances(); ++n2) {
                    instance = instances2.instance(n2);
                    double[] dArray3 = dArray[0];
                    dArray3[0] = dArray3[0] + instance.weight() * instance.classValue();
                }
                double d3 = dArray[0][0] / d;
                d2 = this.meanSquaredError(instances2, d3) * instances2.sumOfWeights();
            }
            double[][] dArray4 = new double[2][this.m_NumClasses];
            for (int i = 0; i < this.m_NumClasses; ++i) {
                if (this.m_ClassAttribute.isNominal()) {
                    dArray4[0][i] = dArray[0][i];
                    dArray4[1][i] = dArray[1][i];
                    continue;
                }
                dArray4[0][i] = dArray[0][i] / d;
                dArray4[1][i] = dArray[1][i];
            }
            this.m_Targets.addElement(dArray4);
            boolean[] blArray = new boolean[instances2.numAttributes()];
            for (n = 0; n < blArray.length; ++n) {
                blArray[n] = false;
            }
            n = blArray.length;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            boolean bl = true;
            while (bl) {
                int n4;
                Serializable serializable;
                double d7 = 0.0;
                Serializable serializable2 = null;
                Instances instances3 = null;
                Instances instances4 = null;
                Enumeration enumeration = instances2.enumerateAttributes();
                int n5 = -1;
                while (enumeration.hasMoreElements()) {
                    double d8;
                    boolean bl2;
                    Instances[] instancesArray;
                    Attribute attribute = (Attribute)enumeration.nextElement();
                    serializable = null;
                    serializable = this.m_ClassAttribute.isNominal() ? (attribute.isNumeric() ? new NumericAntd(attribute, dArray[1]) : new NominalAntd(attribute, dArray[1])) : (attribute.isNumeric() ? new NumericAntd(attribute, d4, d5, d6) : new NominalAntd(attribute, d4, d5, d6));
                    if (blArray[++n5] || (instancesArray = this.computeInfoGain(instances2, d2, (Antd)serializable)) == null || !(bl2 = Utils.gr(d8 = ((Antd)serializable).getMaxInfoGain(), d7))) continue;
                    serializable2 = serializable;
                    instances3 = instancesArray[0];
                    instances4 = instancesArray[1];
                    d7 = d8;
                }
                if (serializable2 == null) break;
                if (!serializable2.getAttr().isNumeric()) {
                    blArray[serializable2.getAttr().index()] = true;
                    --n;
                }
                this.m_Antds.addElement(serializable2);
                instances2 = instances3;
                for (n4 = 0; n4 < instances4.numInstances(); ++n4) {
                    serializable = instances4.instance(n4);
                    if (this.m_ClassAttribute.isNumeric()) {
                        d4 += ((Instance)serializable).weight() * ((Instance)serializable).classValue() * ((Instance)serializable).classValue();
                        d5 += ((Instance)serializable).weight() * ((Instance)serializable).classValue();
                        d6 += ((Instance)serializable).weight();
                        double[] dArray5 = dArray[0];
                        dArray5[0] = dArray5[0] - ((Instance)serializable).weight() * ((Instance)serializable).classValue();
                        double[] dArray6 = dArray[1];
                        dArray6[0] = dArray6[0] + ((Instance)serializable).weight() * ((Instance)serializable).classValue();
                        continue;
                    }
                    double[] dArray7 = dArray[0];
                    int n6 = (int)((Instance)serializable).classValue();
                    dArray7[n6] = dArray7[n6] - ((Instance)serializable).weight();
                    double[] dArray8 = dArray[1];
                    int n7 = (int)((Instance)serializable).classValue();
                    dArray8[n7] = dArray8[n7] + ((Instance)serializable).weight();
                }
                dArray4 = new double[2][this.m_NumClasses];
                for (n4 = 0; n4 < this.m_NumClasses; ++n4) {
                    if (this.m_ClassAttribute.isNominal()) {
                        dArray4[0][n4] = dArray[0][n4];
                        dArray4[1][n4] = dArray[1][n4];
                        continue;
                    }
                    dArray4[0][n4] = dArray[0][n4] / (d - d6);
                    dArray4[1][n4] = dArray[1][n4] / d6;
                }
                this.m_Targets.addElement(dArray4);
                d2 = serializable2.getInfo();
                int n8 = n4 = this.m_NumAntds == -1 ? Integer.MAX_VALUE : this.m_NumAntds;
                if (!Utils.eq(instances2.sumOfWeights(), 0.0) && n != 0 && this.m_Antds.size() < n4) continue;
                bl = false;
            }
        }
        this.m_Cnsqt = ((double[][])this.m_Targets.lastElement())[0];
        this.m_DefDstr = ((double[][])this.m_Targets.lastElement())[1];
    }

    private Instances[] computeInfoGain(Instances instances, double d, Antd antd) {
        int n;
        Instances instances2 = new Instances(instances);
        Instances[] instancesArray = antd.splitData(instances2, d);
        Instances[] instancesArray2 = new Instances[2];
        Instances instances3 = new Instances(instances2, 0);
        Instances instances4 = new Instances(instances2, 0);
        if (instancesArray == null) {
            return null;
        }
        for (n = 0; n < instancesArray.length - 1; ++n) {
            if (n == (int)antd.getAttrValue()) {
                instances3 = instancesArray[n];
                continue;
            }
            for (int i = 0; i < instancesArray[n].numInstances(); ++i) {
                instances4.add(instancesArray[n].instance(i));
            }
        }
        if (antd.getAttr().isNominal()) {
            if (((NominalAntd)antd).isIn()) {
                instancesArray2[0] = new Instances(instances3);
                instancesArray2[1] = new Instances(instances4);
            } else {
                instancesArray2[0] = new Instances(instances4);
                instancesArray2[1] = new Instances(instances3);
            }
        } else {
            instancesArray2[0] = new Instances(instances3);
            instancesArray2[1] = new Instances(instances4);
        }
        for (n = 0; n < instancesArray[instancesArray.length - 1].numInstances(); ++n) {
            instancesArray2[1].add(instancesArray[instancesArray.length - 1].instance(n));
        }
        return instancesArray2;
    }

    private void prune(Instances instances) {
        int n;
        int n2;
        double d;
        Instances instances2 = new Instances(instances);
        Instances instances3 = new Instances(instances2, 0);
        double d2 = instances2.sumOfWeights();
        if (this.m_ClassAttribute.isNumeric()) {
            d = this.meanSquaredError(instances, ((double[][])this.m_Targets.firstElement())[0][0]);
        } else {
            n2 = Utils.maxIndex(((double[][])this.m_Targets.firstElement())[0]);
            d = this.computeAccu(instances, n2) / d2;
        }
        n2 = this.m_Antds.size();
        if (n2 == 0) {
            this.m_Cnsqt = ((double[][])this.m_Targets.lastElement())[0];
            this.m_DefDstr = ((double[][])this.m_Targets.lastElement())[1];
            return;
        }
        double[] dArray = new double[n2];
        for (n = 0; n < n2; ++n) {
            double d3;
            double d4;
            Antd antd = (Antd)this.m_Antds.elementAt(n);
            Instances instances4 = new Instances(instances2);
            if (Utils.eq(instances4.sumOfWeights(), 0.0)) break;
            instances2 = new Instances(instances4, instances4.numInstances());
            for (int i = 0; i < instances4.numInstances(); ++i) {
                Instance instance = instances4.instance(i);
                if (antd.isCover(instance)) {
                    instances2.add(instance);
                    continue;
                }
                instances3.add(instance);
            }
            double[][] dArray2 = (double[][])this.m_Targets.elementAt(n + 1);
            if (this.m_ClassAttribute.isNominal()) {
                int n3 = Utils.maxIndex(dArray2[0]);
                int n4 = Utils.maxIndex(dArray2[1]);
                d4 = this.computeAccu(instances2, n3);
                d3 = this.computeAccu(instances3, n4);
            } else {
                double d5 = dArray2[0][0];
                double d6 = dArray2[1][0];
                d4 = instances2.sumOfWeights() * this.meanSquaredError(instances2, d5);
                d3 = instances3.sumOfWeights() * this.meanSquaredError(instances3, d6);
            }
            dArray[n] = (d4 + d3) / d2;
        }
        for (n = n2 - 1; n > 0; --n) {
            double d7 = this.m_ClassAttribute.isNominal() ? (Utils.sm(dArray[n], 1.0) ? (dArray[n] - dArray[n - 1]) / dArray[n] : dArray[n] - dArray[n - 1]) : (Utils.sm(dArray[n], 1.0) ? (dArray[n - 1] - dArray[n]) / dArray[n] : dArray[n - 1] - dArray[n]);
            if (!Utils.smOrEq(d7, 0.0)) break;
            this.m_Antds.removeElementAt(n);
            this.m_Targets.removeElementAt(n + 1);
        }
        if (this.m_Antds.size() == 1) {
            double d8 = this.m_ClassAttribute.isNominal() ? (Utils.sm(dArray[0], 1.0) ? (dArray[0] - d) / dArray[0] : dArray[0] - d) : (Utils.sm(dArray[0], 1.0) ? (d - dArray[0]) / dArray[0] : d - dArray[0]);
            if (Utils.smOrEq(d8, 0.0)) {
                this.m_Antds.removeAllElements();
                this.m_Targets.removeElementAt(1);
            }
        }
        this.m_Cnsqt = ((double[][])this.m_Targets.lastElement())[0];
        this.m_DefDstr = ((double[][])this.m_Targets.lastElement())[1];
    }

    private double computeAccu(Instances instances, int n) {
        double d = 0.0;
        for (int i = 0; i < instances.numInstances(); ++i) {
            Instance instance = instances.instance(i);
            if ((int)instance.classValue() != n) continue;
            d += instance.weight();
        }
        return d;
    }

    private double meanSquaredError(Instances instances, double d) {
        if (Utils.eq(instances.sumOfWeights(), 0.0)) {
            return 0.0;
        }
        double d2 = 0.0;
        double d3 = instances.sumOfWeights();
        for (int i = 0; i < instances.numInstances(); ++i) {
            Instance instance = instances.instance(i);
            d2 += instance.weight() * (instance.classValue() - d) * (instance.classValue() - d);
        }
        return d2 / d3;
    }

    public String toString(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_Antds.size() > 0) {
            for (int i = 0; i < this.m_Antds.size() - 1; ++i) {
                stringBuffer.append("(" + ((Antd)this.m_Antds.elementAt(i)).toString() + ") and ");
            }
            stringBuffer.append("(" + ((Antd)this.m_Antds.lastElement()).toString() + ")");
        }
        stringBuffer.append(" => " + string + " = " + string2);
        return stringBuffer.toString();
    }

    public String toString() {
        String string = "\n\nSingle conjunctive rule learner:\n--------------------------------\n";
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_ClassAttribute != null) {
            if (this.m_ClassAttribute.isNominal()) {
                int n;
                string2 = this.toString(this.m_ClassAttribute.name(), this.m_ClassAttribute.value(Utils.maxIndex(this.m_Cnsqt)));
                stringBuffer.append("\n\nClass distributions:\nCovered by the rule:\n");
                for (n = 0; n < this.m_Cnsqt.length; ++n) {
                    stringBuffer.append(this.m_ClassAttribute.value(n) + "\t");
                }
                stringBuffer.append('\n');
                for (n = 0; n < this.m_Cnsqt.length; ++n) {
                    stringBuffer.append(Utils.doubleToString(this.m_Cnsqt[n], 6) + "\t");
                }
                stringBuffer.append("\n\nNot covered by the rule:\n");
                for (n = 0; n < this.m_DefDstr.length; ++n) {
                    stringBuffer.append(this.m_ClassAttribute.value(n) + "\t");
                }
                stringBuffer.append('\n');
                for (n = 0; n < this.m_DefDstr.length; ++n) {
                    stringBuffer.append(Utils.doubleToString(this.m_DefDstr[n], 6) + "\t");
                }
            } else {
                string2 = this.toString(this.m_ClassAttribute.name(), Utils.doubleToString(this.m_Cnsqt[0], 6));
            }
        }
        return string + string2 + stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        ConjunctiveRule.runClassifier(new ConjunctiveRule(), stringArray);
    }

    class NominalAntd
    extends Antd {
        static final long serialVersionUID = -5949864163376447424L;
        private double[][] stats;
        private double[] coverage;
        private boolean isIn;

        public NominalAntd(Attribute attribute, double[] dArray) {
            super(attribute, dArray);
            int n = this.att.numValues();
            this.stats = new double[n][ConjunctiveRule.this.m_NumClasses];
            this.coverage = new double[n];
            this.isIn = true;
        }

        public NominalAntd(Attribute attribute, double d, double d2, double d3) {
            super(attribute, d, d2, d3);
            int n = this.att.numValues();
            this.stats = null;
            this.coverage = new double[n];
            this.isIn = true;
        }

        public Instances[] splitData(Instances instances, double d) {
            int n;
            int n2;
            int n3 = this.att.numValues();
            Instances[] instancesArray = new Instances[n3 + 1];
            double[] dArray = new double[n3];
            double[] dArray2 = new double[n3];
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = instances.sumOfWeights();
            double[] dArray3 = new double[ConjunctiveRule.this.m_NumClasses];
            double[] dArray4 = new double[ConjunctiveRule.this.m_NumClasses];
            for (n2 = 0; n2 < ConjunctiveRule.this.m_NumClasses; ++n2) {
                dArray4[n2] = 0.0;
                dArray3[n2] = 0.0;
            }
            for (n2 = 0; n2 < n3; ++n2) {
                dArray2[n2] = 0.0;
                dArray[n2] = 0.0;
                this.coverage[n2] = 0.0;
                if (this.stats != null) {
                    for (int i = 0; i < ConjunctiveRule.this.m_NumClasses; ++i) {
                        this.stats[n2][i] = 0.0;
                    }
                }
                instancesArray[n2] = new Instances(instances, instances.numInstances());
            }
            instancesArray[n3] = new Instances(instances, instances.numInstances());
            for (n2 = 0; n2 < instances.numInstances(); ++n2) {
                Instance instance = instances.instance(n2);
                if (!instance.isMissing(this.att)) {
                    int n4 = (int)instance.value(this.att);
                    instancesArray[n4].add(instance);
                    int n5 = n4;
                    this.coverage[n5] = this.coverage[n5] + instance.weight();
                    if (ConjunctiveRule.this.m_ClassAttribute.isNominal()) {
                        double[] dArray5 = this.stats[n4];
                        int n6 = (int)instance.classValue();
                        dArray5[n6] = dArray5[n6] + instance.weight();
                        int n7 = (int)instance.classValue();
                        dArray3[n7] = dArray3[n7] + instance.weight();
                        continue;
                    }
                    int n8 = n4;
                    dArray[n8] = dArray[n8] + instance.weight() * instance.classValue() * instance.classValue();
                    int n9 = n4;
                    dArray2[n9] = dArray2[n9] + instance.weight() * instance.classValue();
                    d2 += instance.weight() * instance.classValue() * instance.classValue();
                    d3 += instance.weight() * instance.classValue();
                    continue;
                }
                instancesArray[n3].add(instance);
                if (ConjunctiveRule.this.m_ClassAttribute.isNominal()) {
                    int n10 = (int)instance.classValue();
                    dArray3[n10] = dArray3[n10] + instance.weight();
                    int n11 = (int)instance.classValue();
                    dArray4[n11] = dArray4[n11] + instance.weight();
                    continue;
                }
                d2 += instance.weight() * instance.classValue() * instance.classValue();
                d3 += instance.weight() * instance.classValue();
                d4 += instance.weight() * instance.classValue() * instance.classValue();
                d5 += instance.weight() * instance.classValue();
            }
            double d7 = ConjunctiveRule.this.m_ClassAttribute.isNominal() ? d6 + Utils.sum(this.uncover) : d6 + this.uncoverSum;
            double d8 = Double.MAX_VALUE;
            this.maxInfoGain = 0.0;
            int n12 = 0;
            for (n = 0; n < n3; ++n) {
                if (!Utils.grOrEq(this.coverage[n], ConjunctiveRule.this.m_MinNo)) continue;
                ++n12;
            }
            if (n12 < 2) {
                this.maxInfoGain = 0.0;
                this.inform = d;
                this.value = Double.NaN;
                return null;
            }
            for (n = 0; n < n3; ++n) {
                double d9;
                double d10;
                double d11;
                double d12;
                double d13 = this.coverage[n];
                if (Utils.sm(d13, ConjunctiveRule.this.m_MinNo)) continue;
                if (ConjunctiveRule.this.m_ClassAttribute.isNominal()) {
                    double[] dArray6 = new double[ConjunctiveRule.this.m_NumClasses];
                    for (int i = 0; i < ConjunctiveRule.this.m_NumClasses; ++i) {
                        dArray6[i] = dArray3[i] - this.stats[n][i] + this.uncover[i];
                    }
                    d12 = d7 - d13;
                    d11 = this.entropy(this.stats[n], d13);
                    d10 = this.entropy(dArray6, d12);
                    d9 = d - (d11 * d13 + d10 * d12) / d7;
                } else {
                    double d14 = d7 - d13;
                    d11 = this.wtMeanSqErr(dArray[n], dArray2[n], d13) / d13;
                    d9 = d - d11 * d13 - this.wtMeanSqErr(d2 - dArray[n] + this.uncoverWtSq, d3 - dArray2[n] + this.uncoverWtVl, d14);
                }
                boolean bl = true;
                if (ConjunctiveRule.this.m_IsExclude) {
                    double d15;
                    if (ConjunctiveRule.this.m_ClassAttribute.isNominal()) {
                        double[] dArray7 = new double[ConjunctiveRule.this.m_NumClasses];
                        double[] dArray8 = new double[ConjunctiveRule.this.m_NumClasses];
                        for (int i = 0; i < ConjunctiveRule.this.m_NumClasses; ++i) {
                            dArray7[i] = this.stats[n][i] + dArray4[i] + this.uncover[i];
                            dArray8[i] = dArray3[i] - this.stats[n][i] - dArray4[i];
                        }
                        d15 = Utils.sum(dArray4);
                        double d16 = d13 + d15 + Utils.sum(this.uncover);
                        d10 = this.entropy(dArray8, d6 - d13 - d15);
                        double d17 = this.entropy(dArray7, d16);
                        d12 = d - (d10 * (d6 - d13 - d15) + d17 * d16) / d7;
                    } else {
                        double d18 = instancesArray[n3].sumOfWeights();
                        d15 = d13 + this.uncoverSum + d18;
                        d10 = this.wtMeanSqErr(d2 - dArray[n] - d4, d3 - dArray2[n] - d5, d6 - d13 - d18) / (d6 - d13 - d18);
                        d12 = d - d10 * (d6 - d13 - d18) - this.wtMeanSqErr(dArray[n] + this.uncoverWtSq + d4, dArray2[n] + this.uncoverWtVl + d5, d15);
                    }
                    if (Utils.gr(d12, d9) || Utils.eq(d12, d9) && Utils.sm(d10, d11)) {
                        d9 = d12;
                        d11 = d10;
                        bl = false;
                    }
                }
                if (!Utils.gr(d9, this.maxInfoGain) && (!Utils.eq(d9, this.maxInfoGain) || !Utils.sm(d11, d8))) continue;
                this.value = n;
                this.maxInfoGain = d9;
                this.inform = this.maxInfoGain - d;
                d8 = d11;
                this.isIn = bl;
            }
            return instancesArray;
        }

        public boolean isCover(Instance instance) {
            boolean bl = false;
            if (!instance.isMissing(this.att)) {
                if (this.isIn) {
                    if (Utils.eq(instance.value(this.att), this.value)) {
                        bl = true;
                    }
                } else if (!Utils.eq(instance.value(this.att), this.value)) {
                    bl = true;
                }
            }
            return bl;
        }

        public boolean isIn() {
            return this.isIn;
        }

        public String toString() {
            String string = this.isIn ? " = " : " != ";
            return this.att.name() + string + this.att.value((int)this.value);
        }
    }

    private class NumericAntd
    extends Antd {
        static final long serialVersionUID = -7957266498918210436L;
        private double splitPoint;

        public NumericAntd(Attribute attribute, double[] dArray) {
            super(attribute, dArray);
            this.splitPoint = Double.NaN;
        }

        public NumericAntd(Attribute attribute, double d, double d2, double d3) {
            super(attribute, d, d2, d3);
            this.splitPoint = Double.NaN;
        }

        public double getSplitPoint() {
            return this.splitPoint;
        }

        public Instances[] splitData(Instances instances, double d) {
            Instance instance;
            int n;
            double d2;
            Instances instances2 = new Instances(instances);
            instances2.sort(this.att);
            int n2 = instances2.numInstances();
            this.maxInfoGain = 0.0;
            this.value = 0.0;
            if (ConjunctiveRule.this.m_ClassAttribute.isNominal()) {
                d2 = 0.1 * instances2.sumOfWeights() / (double)ConjunctiveRule.this.m_ClassAttribute.numValues();
                if (Utils.smOrEq(d2, ConjunctiveRule.this.m_MinNo)) {
                    d2 = ConjunctiveRule.this.m_MinNo;
                } else if (Utils.gr(d2, 25.0)) {
                    d2 = 25.0;
                }
            } else {
                d2 = ConjunctiveRule.this.m_MinNo;
            }
            double[] dArray = null;
            double[] dArray2 = null;
            double[] dArray3 = null;
            if (ConjunctiveRule.this.m_ClassAttribute.isNominal()) {
                dArray = new double[ConjunctiveRule.this.m_NumClasses];
                dArray2 = new double[ConjunctiveRule.this.m_NumClasses];
                dArray3 = new double[ConjunctiveRule.this.m_NumClasses];
                for (int i = 0; i < ConjunctiveRule.this.m_NumClasses; ++i) {
                    dArray3[i] = 0.0;
                    dArray2[i] = 0.0;
                    dArray[i] = 0.0;
                }
            }
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            double d7 = 0.0;
            double d8 = 0.0;
            int n3 = 1;
            int n4 = 0;
            int n5 = n3;
            for (int i = 0; i < instances2.numInstances(); ++i) {
                Instance instance2 = instances2.instance(i);
                if (instance2.isMissing(this.att)) {
                    n2 = i;
                    break;
                }
                d4 += instance2.weight();
                if (ConjunctiveRule.this.m_ClassAttribute.isNominal()) {
                    int n6 = (int)instance2.classValue();
                    dArray2[n6] = dArray2[n6] + instance2.weight();
                    continue;
                }
                d6 += instance2.weight() * instance2.classValue() * instance2.classValue();
                d8 += instance2.weight() * instance2.classValue();
            }
            if (Utils.sm(d4, 2.0 * d2)) {
                return null;
            }
            double d9 = 0.0;
            double d10 = 0.0;
            Instances instances3 = new Instances(instances2, 0);
            for (n = n2; n < instances2.numInstances(); ++n) {
                instance = instances2.instance(n);
                instances3.add(instance);
                if (ConjunctiveRule.this.m_ClassAttribute.isNominal()) {
                    int n7 = (int)instance.classValue();
                    dArray3[n7] = dArray3[n7] + instance.weight();
                    continue;
                }
                d9 += instance.weight() * instance.classValue() * instance.classValue();
                d10 += instance.weight() * instance.classValue();
            }
            if (n2 == 0) {
                return null;
            }
            this.splitPoint = instances2.instance(n2 - 1).value(this.att);
            while (n3 < n2) {
                if (!Utils.eq(instances2.instance(n3).value(this.att), instances2.instance(n4).value(this.att))) {
                    for (n = n4; n < n3; ++n) {
                        instance = instances2.instance(n);
                        d3 += instance.weight();
                        d4 -= instance.weight();
                        if (ConjunctiveRule.this.m_ClassAttribute.isNominal()) {
                            int n8 = (int)instance.classValue();
                            dArray[n8] = dArray[n8] + instance.weight();
                            int n9 = (int)instance.classValue();
                            dArray2[n9] = dArray2[n9] - instance.weight();
                            continue;
                        }
                        d5 += instance.weight() * instance.classValue() * instance.classValue();
                        d7 += instance.weight() * instance.classValue();
                        d6 -= instance.weight() * instance.classValue() * instance.classValue();
                        d8 -= instance.weight() * instance.classValue();
                    }
                    if (Utils.sm(d3, d2) || Utils.sm(d4, d2)) {
                        n4 = n3;
                    } else {
                        double d11;
                        double d12;
                        boolean bl;
                        double d13;
                        double d14;
                        double d15;
                        double d16;
                        double d17;
                        double d18;
                        double d19;
                        double d20;
                        double d21 = 0.0;
                        double d22 = 0.0;
                        if (ConjunctiveRule.this.m_ClassAttribute.isNominal()) {
                            d21 = this.entropy(dArray, d3);
                            d22 = this.entropy(dArray2, d4);
                        } else {
                            d21 = this.wtMeanSqErr(d5, d7, d3) / d3;
                            d22 = this.wtMeanSqErr(d6, d8, d4) / d4;
                        }
                        if (ConjunctiveRule.this.m_ClassAttribute.isNominal()) {
                            int n10;
                            d20 = instances2.sumOfWeights();
                            d19 = d20 + Utils.sum(this.uncover);
                            double[] dArray4 = null;
                            dArray4 = new double[ConjunctiveRule.this.m_NumClasses];
                            for (n10 = 0; n10 < ConjunctiveRule.this.m_NumClasses; ++n10) {
                                dArray4[n10] = this.uncover[n10] + dArray2[n10] + dArray3[n10];
                            }
                            d18 = d19 - d3;
                            d17 = this.entropy(dArray4, d18);
                            d16 = (d21 * d3 + d17 * d18) / d19;
                            d15 = d - d16;
                            dArray4 = new double[ConjunctiveRule.this.m_NumClasses];
                            for (n10 = 0; n10 < ConjunctiveRule.this.m_NumClasses; ++n10) {
                                dArray4[n10] = this.uncover[n10] + dArray[n10] + dArray3[n10];
                            }
                            d18 = d19 - d4;
                            d17 = this.entropy(dArray4, d18);
                            d14 = (d22 * d4 + d17 * d18) / d19;
                            d13 = d - d14;
                        } else {
                            d20 = instances2.sumOfWeights();
                            d18 = d6 + d9 + this.uncoverWtSq;
                            d19 = d8 + d10 + this.uncoverWtVl;
                            d17 = d20 - d3 + this.uncoverSum;
                            d16 = Utils.eq(d3, 0.0) ? 0.0 : d21 * d3;
                            d15 = d - (d16 += this.wtMeanSqErr(d18, d19, d17));
                            d18 = d5 + d9 + this.uncoverWtSq;
                            d19 = d7 + d10 + this.uncoverWtVl;
                            d17 = d20 - d4 + this.uncoverSum;
                            d14 = Utils.eq(d4, 0.0) ? 0.0 : d22 * d4;
                            d13 = d - (d14 += this.wtMeanSqErr(d18, d19, d17));
                        }
                        if (Utils.gr(d15, d13) || Utils.eq(d15, d13) && Utils.sm(d21, d22)) {
                            bl = true;
                            d12 = d15;
                            d11 = d16;
                        } else {
                            bl = false;
                            d12 = d13;
                            d11 = d14;
                        }
                        boolean bl2 = Utils.gr(d12, this.maxInfoGain);
                        if (bl2) {
                            this.splitPoint = (instances2.instance(n3).value(this.att) + instances2.instance(n4).value(this.att)) / 2.0;
                            this.value = !bl ? 1 : 0;
                            this.inform = d11;
                            this.maxInfoGain = d12;
                            n5 = n3;
                        }
                        n4 = n3;
                    }
                }
                ++n3;
            }
            Instances[] instancesArray = new Instances[]{new Instances(instances2, 0, n5), new Instances(instances2, n5, n2 - n5), new Instances(instances3)};
            return instancesArray;
        }

        public boolean isCover(Instance instance) {
            boolean bl = false;
            if (!instance.isMissing(this.att)) {
                if (Utils.eq(this.value, 0.0)) {
                    if (Utils.smOrEq(instance.value(this.att), this.splitPoint)) {
                        bl = true;
                    }
                } else if (Utils.gr(instance.value(this.att), this.splitPoint)) {
                    bl = true;
                }
            }
            return bl;
        }

        public String toString() {
            String string = Utils.eq(this.value, 0.0) ? " <= " : " > ";
            return this.att.name() + string + Utils.doubleToString(this.splitPoint, 6);
        }
    }

    private abstract class Antd
    implements Serializable {
        protected Attribute att;
        protected double value;
        protected double maxInfoGain;
        protected double inform;
        protected double uncoverWtSq;
        protected double uncoverWtVl;
        protected double uncoverSum;
        protected double[] uncover;

        public Antd(Attribute attribute, double[] dArray) {
            this.att = attribute;
            this.value = Double.NaN;
            this.maxInfoGain = 0.0;
            this.inform = Double.NaN;
            this.uncover = dArray;
        }

        public Antd(Attribute attribute, double d, double d2, double d3) {
            this.att = attribute;
            this.value = Double.NaN;
            this.maxInfoGain = 0.0;
            this.inform = Double.NaN;
            this.uncoverWtSq = d;
            this.uncoverWtVl = d2;
            this.uncoverSum = d3;
        }

        public abstract Instances[] splitData(Instances var1, double var2);

        public abstract boolean isCover(Instance var1);

        public abstract String toString();

        public Attribute getAttr() {
            return this.att;
        }

        public double getAttrValue() {
            return this.value;
        }

        public double getMaxInfoGain() {
            return this.maxInfoGain;
        }

        public double getInfo() {
            return this.inform;
        }

        protected double wtMeanSqErr(double d, double d2, double d3) {
            if (Utils.smOrEq(d3, 1.0E-6)) {
                return 0.0;
            }
            return d - d2 * d2 / d3;
        }

        protected double entropy(double[] dArray, double d) {
            if (Utils.smOrEq(d, 1.0E-6)) {
                return 0.0;
            }
            double d2 = 0.0;
            for (int i = 0; i < dArray.length; ++i) {
                if (Utils.eq(dArray[i], 0.0)) continue;
                d2 -= dArray[i] * Utils.log2(dArray[i]);
            }
            d2 += d * Utils.log2(d);
            return d2 /= d;
        }
    }
}

