/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.x11;

import ec.satoolkit.x11.TrendCycleFilterFactory;
import ec.tstoolkit.maths.linearfilters.FiniteFilter;
import ec.tstoolkit.maths.linearfilters.IFiniteFilter;
import ec.tstoolkit.maths.polynomials.Polynomial;
import java.util.HashMap;
import java.util.Map;

public class MusgraveFilterFactory {
    private static final Map<Integer, FiniteFilter[]> mfilterStore = new HashMap<Integer, FiniteFilter[]>();
    private static final Map<Integer, FiniteFilter[]> qfilterStore = new HashMap<Integer, FiniteFilter[]>();
    private static final Polynomial X11_H1 = Polynomial.valueOf(-0.073, 0.294, 0.522, 0.257);
    private static final Polynomial X11_H0 = Polynomial.valueOf(-0.073, 0.403, 0.67);

    private static Polynomial computeCoefficients(double[] h, double D, int M) {
        double[] c = new double[M];
        int N = h.length;
        int i = 0;
        while (i < M) {
            c[i] = h[i];
            double p1 = 0.0;
            double p2 = 0.0;
            for (int j = M; j < N; ++j) {
                p1 += h[j];
                p2 += h[j] * ((double)(j + 1) - (double)(M + 1) / 2.0);
            }
            int n = i++;
            c[n] = c[n] + ((p1 /= (double)M) + (p2 *= ((double)(i + 1) - (double)(M + 1) / 2.0) * D / (1.0 + (double)(M * (M - 1) * (M + 1)) * D * 0.08333333333333333)));
        }
        return Polynomial.of(c);
    }

    private static double findR(int length, int frequency) {
        if (frequency == 4) {
            return length <= 5 ? 0.001 : 4.5;
        }
        if (frequency == 2) {
            return 0.001;
        }
        if (length <= 9) {
            return 1.0;
        }
        if (length <= 13) {
            return 3.5;
        }
        return 4.5;
    }

    private static Map<Integer, FiniteFilter[]> getFilterStore(int freq) {
        if (freq == 12) {
            return mfilterStore;
        }
        if (freq == 4) {
            return qfilterStore;
        }
        return null;
    }

    public static FiniteFilter[] makeFilters(IFiniteFilter filter, double ic) {
        double D = 4.0 / (Math.PI * ic * ic);
        int len = filter.getUpperBound();
        if (len <= 0) {
            return null;
        }
        FiniteFilter[] filters = new FiniteFilter[len];
        double[] h = filter.getWeights();
        for (int i = 1; i <= len; ++i) {
            Polynomial w = MusgraveFilterFactory.computeCoefficients(h, D, h.length - i);
            filters[i - 1] = new FiniteFilter(w, filter.getLowerBound());
        }
        return filters;
    }

    public static synchronized IFiniteFilter[] makeFiltersForHenderson(int len, int freq) {
        FiniteFilter[] filters;
        Map<Integer, FiniteFilter[]> filterstore = MusgraveFilterFactory.getFilterStore(freq);
        FiniteFilter[] finiteFilterArray = filters = filterstore != null ? filterstore.get(len) : null;
        if (filters == null) {
            filters = new FiniteFilter[len / 2];
            double r = MusgraveFilterFactory.findR(len, freq);
            double D = 4.0 / (Math.PI * r * r);
            double[] h = TrendCycleFilterFactory.makeHendersonFilter(len).getWeights();
            int l2 = len / 2;
            for (int i = 1; i <= l2; ++i) {
                Polynomial w = MusgraveFilterFactory.computeCoefficients(h, D, len - i);
                filters[i - 1] = new FiniteFilter(w, -l2);
            }
            if (filterstore != null) {
                filterstore.put(len, filters);
            }
        }
        return (IFiniteFilter[])filters.clone();
    }

    public static FiniteFilter[] makeX11Filters() {
        return new FiniteFilter[]{new FiniteFilter(X11_H1, -2), new FiniteFilter(X11_H0, -2)};
    }
}

